/* misc.c
Copyright (c) 2000-2002 Craig Condit, Stefan Hlswitt.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met: 

1. Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer. 
2. Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution. 

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/wait.h>
#include <errno.h>

extern char *prg_name;

/****************************************************************************/

void error(char *text)
{
  fprintf(stderr,"%s: %s: %s\n",prg_name,text,strerror(errno));
  exit(1);
}

/****************************************************************************/

void serror(char *text)
{
  fprintf(stderr,"%s: %s\n",prg_name,text);
  exit(1);
}

/****************************************************************************/

int start_diskchange(char *multicmd, char *cd_dev)
{
int pid, status=0;
char buffer[12];

if(multicmd) { /* we have an external script */
  if((pid=fork())<0) error("Fork failed in diskchange");
  if(pid==0) { /* child */
    char *argv[3];

    dup2(2,0); dup2(2,1); /* duplicate stderr as stdin/stdout */
    argv[0] = multicmd;
    argv[1] = cd_dev;
    argv[2] = 0;
    execvp(multicmd, argv);
    error("Starting diskchange command failed");
    }

  while(1) {
    if(waitpid(pid,&status,0)==-1) { if (errno != EINTR) { status=-1; break; } }
    else break;
    }
  }
else { /* use internal diskchange */
  fprintf(stderr,"\n\nPlease insert next disk and press RETURN\n\n\n");
  do {
    pid=read(2,buffer,sizeof(buffer));
    } while(pid==sizeof(buffer) && buffer[sizeof(buffer)-1]!='\n');
  }
return status;
}
