/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"
#include "GRID_F.H"

#define DIMS lo_1,lo_2,hi_1,hi_2

c *************************************************************************
c ** MKFORCE **
c ** Define the forcing terms in the momentum equation
c ***************************************************************

      subroutine FORT_MKFORCE(force,u,rho,gravity,visc_coef,time,dx,DIMS)

      implicit none

      integer DIMS

      REAL_T  force(lo_1-1:hi_1+1,lo_2-1:hi_2+1,2)
      REAL_T      u(lo_1-3:hi_1+3,lo_2-3:hi_2+3,2)
      REAL_T    rho(lo_1-3:hi_1+3,lo_2-3:hi_2+3)
      REAL_T  gravity
      REAL_T  time
      REAL_T  dx(2)
      REAL_T  visc_coef

c     Local variables
      integer i,j 

      do j = lo_2-1,hi_2+1
      do i = lo_1-1,hi_1+1
        force(i,j,1) = zero
        force(i,j,2) = gravity
      enddo
      enddo

      return
      end

#include "ArrayLim.H" 
      subroutine FORT_KINE(u,DIMS(u),xmean,ymean,tix,tiy,lo,hi)
      implicit none
      integer DIMDEC(u)
      integer lo(2), hi(2)
      REAL_T  u(DIMV(u),2)
      REAL_T  xmean,ymean,tix,tiy
      integer i,j

      do j = lo(2),hi(2)
      do i = lo(1),hi(1)
             xmean = xmean + u(i,j,1)
             ymean = ymean + u(i,j,2)
             tix = tix + u(i,j,1)**2
             tiy = tiy + u(i,j,2)**2
      enddo
      enddo
      end


      subroutine FORT_WRITEVEL(u,DIMS(u),lo,hi,psize)
      implicit none
      integer DIMDEC(u)
      integer lo(2), hi(2)
      REAL_T  u(DIMV(u),2)
      REAL_T  psize(2)
      integer i,j,n

      open(3,file='Turb',form='formatted') 
      rewind 3
      write(3,*)hi(1)-lo(1)+1,hi(2)-lo(2)+1,1
      write(3,*)psize(1),psize(2),1.d0
      write(3,*)1,1,1
      do n = 1,3
      do j = lo(2),hi(2)
      do i = lo(1),hi(1)
         write(3,*)u(i,j,n)
      enddo
      enddo
      enddo

      close(3)
      end
