/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#include "REAL.H"
#include "CONSTANTS.H"
#include "BCTypes.H"

#if BL_USE_FLOAT
#define threehalves    1.5e0
#else
#define threehalves    1.5d0
#endif

#define DIMS lo_1,lo_2,hi_1,hi_2
#define SDIMS slo_1,slo_2,shi_1,shi_2

c *************************************************************************
c ** SETSCALBC **
c ** Impose the physical boundary conditions on scalars s
c *************************************************************************

      subroutine setscalbc(s,DIMS,SDIMS,bc,irz,which_scal,dx,time)

      implicit none

      integer DIMS
      integer SDIMS
      integer which_scal
      integer bc(2,2)
      integer irz
      REAL_T  dx(2)
      REAL_T  time
      REAL_T  s(slo_1:shi_1,slo_2:shi_2)

c     Local variables
      integer is,ie,js,je,i,j
      integer ilo,ihi
      integer ng,ngmax

      is = lo_1
      ie = hi_1
      js = lo_2
      je = hi_2

      ilo = cvmgt(slo_1,lo_1,BCX_LO .eq. INTERIOR .or. BCX_LO .eq. PERIODIC)
      ihi = cvmgt(shi_1,hi_1,BCX_HI .eq. INTERIOR .or. BCX_HI .eq. PERIODIC)

      ngmax = lo_1-slo_1

c     NOTE: IF BC == WALL, THESE VALUES ARE DEFINED ON THE EDGE OF THE PHYSICAL 
c           BOUNDARY, NOT IN THE GHOST CELL

      if (BCY_LO .eq. WALL) then

        do ng = 1,ngmax
        do i = ilo,ihi
c         s(i,js-1 ) = threehalves*s(i,js) - half*s(i,js+1)
          s(i,js-ng) = s(i,js)
        enddo
        enddo

      elseif (BCY_LO .eq. INLET) then

        call scalinflow(s,DIMS,SDIMS,time,dx,1,0,which_scal)
        if (ngmax .gt. 1) then
          do ng = 2,ngmax
          do i = slo_1,shi_1
            s(i,js-ng) = s(i,js-1)
          enddo
          enddo
        endif

      elseif (BCY_LO .eq. OUTLET) then

        do ng = 1,ngmax
        do i = ilo,ihi
c         s(i,js-1) = threehalves*s(i,js) - half*s(i,js+1)
          s(i,js-ng) = s(i,js)
        enddo
        enddo

      endif

      if (BCY_HI .eq. WALL) then

        do ng = 1,ngmax
        do i = ilo,ihi
c         s(i,je+1 ) = threehalves*s(i,je) - half*s(i,je-1)
          s(i,je+ng) = s(i,je)
        enddo
        enddo

      elseif (BCY_HI .eq. INLET) then

        call scalinflow(s,DIMS,SDIMS,time,dx,1,1,which_scal)
        if (ngmax .gt. 1) then
          do ng = 2,ngmax
          do i = slo_1,shi_1
            s(i,je+ng) = s(i,je+1)
          enddo
          enddo
        endif

      elseif (BCY_HI .eq. OUTLET) then

        do ng = 1,ngmax
        do i = ilo,ihi
c         s(i,je+1) = threehalves*s(i,je) - half*s(i,je-1)
          s(i,je+ng) = s(i,je)
        enddo
        enddo

      endif

      if (BCX_LO .eq. WALL) then

        if (irz .eq. 1) then

          do ng = 1,ngmax
          do j = js-ngmax,je+ngmax 
            s(is-ng,j) = s(is+ng-1,j)
          enddo
          enddo

        else

          do ng = 1,ngmax
          do j = js-ngmax,je+ngmax 
c           s(is-1,j) = threehalves*s(is,j) - half*s(is+1,j)
            s(is-ng,j) = s(is,j)
          enddo
          enddo

        endif

      elseif (BCX_LO .eq. INLET) then

        call scalinflow(s,DIMS,SDIMS,time,dx,0,0,which_scal)
        if (ngmax .gt. 2) then
          do ng = 2,ngmax
           do j = js-ngmax,je+ngmax
            s(is-ng,j) = s(is-1,j)
          enddo
         enddo
        endif

      elseif (BCX_LO .eq. OUTLET) then

        do ng = 1,ngmax
        do j = js-ngmax,je+ngmax 
c         s(is-1,j) = threehalves*s(is,j) - half*s(is+1,j)
          s(is-ng,j) = s(is,j)
        enddo
        enddo

      endif

      if (BCX_HI .eq. WALL) then

        do ng = 1,ngmax
        do j = js-ngmax,je+ngmax
c         s(ie+1,j) = threehalves*s(ie,j) - half*s(ie-1,j)
          s(ie+ng,j) = s(ie,j)
        enddo
        enddo

      elseif (BCX_HI .eq. INLET) then

        call scalinflow(s,DIMS,SDIMS,time,dx,0,1,which_scal)
        if (ngmax .gt. 2) then
         do ng = 2,ngmax
          do j = js-ngmax,je+ngmax
            s(ie+ng,j) = s(ie+1,j)
          enddo
         enddo
        endif

      elseif (BCX_HI .eq. OUTLET) then

        do ng = 1,ngmax
        do j = js-ngmax,je+ngmax 
c         s(ie+1,j) = threehalves*s(ie,j) - half*s(ie-1,j)
          s(ie+ng,j) = s(ie,j)
        enddo
        enddo

      endif

c     We return to these to get the corner regions which are
c      part INTERIOR and part WALL / OUTFLOW

      if (BCY_LO .eq. WALL) then

        do ng = 1,ngmax
        do i = is-ngmax,is-1
c         s(i,js-1 ) = threehalves*s(i,js) - half*s(i,js+1)
          s(i,js-ng) = s(i,js)
        enddo
        do i = ie+1,ie+ngmax
c         s(i,js-1 ) = threehalves*s(i,js) - half*s(i,js+1)
          s(i,js-ng) = s(i,js)
        enddo
        enddo

      elseif (BCY_LO .eq. OUTLET) then

        do ng = 1,ngmax
        do i = is-ngmax,is-1
c         s(i,js-1) = threehalves*s(i,js) - half*s(i,js+1)
          s(i,js-ng) = s(i,js)
        enddo
        do i = ie+1,ie+ngmax
c         s(i,js-1) = threehalves*s(i,js) - half*s(i,js+1)
          s(i,js-ng) = s(i,js)
        enddo
        enddo

      endif

      if (BCY_HI .eq. WALL) then

        do ng = 1,ngmax
        do i = is-ngmax,is-1
c         s(i,je+1 ) = threehalves*s(i,je) - half*s(i,je-1)
          s(i,je+ng) = s(i,je)
        enddo
        do i = ie+1,ie+ngmax
c         s(i,je+1 ) = threehalves*s(i,je) - half*s(i,je-1)
          s(i,je+ng) = s(i,je)
        enddo
        enddo

      elseif (BCY_HI .eq. OUTLET) then

        do ng = 1,ngmax
        do i = is-ngmax,is-1
c         s(i,je+1) = threehalves*s(i,je) - half*s(i,je-1)
          s(i,je+ng) = s(i,je)
        enddo
        do i = ie+1,ie+ngmax 
c         s(i,je+1) = threehalves*s(i,je) - half*s(i,je-1)
          s(i,je+ng) = s(i,je)
        enddo
        enddo

      endif

      return
      end
