#include <stdio.h>
#include <string.h>

#define MAX_PY_NUM 420
#define MAX_EACH_PY 38
#define MAX_EACH_HZ 241

/* Important,need change according to assoc.h */
#define MAX_PHRASE_LEN 6

typedef struct {
  unsigned short key;
  char py[7];
} PinYin;

PinYin pytab[26][MAX_EACH_PY];
char hztab[MAX_PY_NUM][MAX_EACH_HZ]; 

int LoadTable()
{

  FILE *stream;
  char str[250],strpy[15],strhz[241];
  int i=0,j=0;
  int tmp,curpy;
  PinYin *pyt=(PinYin *)pytab;

  if( (stream = fopen( "/usr/local/lib/pyinput.dic/table", "r" )) == NULL ){
    fprintf(stderr,"/usr/local/lib/pyinput.dic/table not found\n");
    exit(1);
  }

  while( !feof( stream )) {
    if( fgets(str,250,stream)!=NULL){
      sscanf(str,"%s %s",strpy,strhz);

      strcpy( hztab[i],strhz);

      curpy=strpy[0]-97;
      if(curpy!=tmp) {j=0;}
      strcpy( (pyt+curpy*MAX_EACH_PY+j)->py,strpy);
      (pyt+curpy*MAX_EACH_PY+j)->key=i+1;
      tmp=curpy;

      i++,j++;
    }
  }

  fclose(stream);
  return (0);
}

int sim2lib(inname,outname)
     char *inname;
     char *outname;
{
  FILE *stream,*out;
  int i,j;
  char str[250],strtmp[3];
  int len,result;
  char *pdest;
  unsigned char key[MAX_PHRASE_LEN+1],clen;
  short pykey[MAX_PHRASE_LEN];
  int count;

  if( (stream = fopen( inname, "r" )) == NULL ){
    fprintf(stderr,"%s cant open.\n",inname);
    exit(1);
  }

  if( (out = fopen( outname, "wb" )) == NULL ){
    fprintf(stderr,"%s cant open.\n",outname);
    exit(1);
  }

  strtmp[2]='\0';
  while( !feof( stream )) {
    if( fgets(str,250,stream)!=NULL){
      len=strlen(str)/2;

      if(len > MAX_PHRASE_LEN) continue;

      for(i=0;i<len;i++){
	strtmp[0]=str[2*i];
	strtmp[1]=str[2*i+1];
	count=0;
	for(j=0;j<MAX_PY_NUM;j++) {
	  pdest = strstr( hztab[j],strtmp);
	  result = pdest- hztab[j];
	  if(pdest!= NULL && !(result%2) ){
	    pykey[i]=j+1;
	    count++;
	  }
	}
	if(count!=1) break;
      }
      if(count!=1){
	*(str+strlen(str)-1)='\0';
	printf("%s(%s %d)\n",str,strtmp,count);
	continue;
      }
      for(i=0;i<len;i++)
	key[i+1]=pykey[i] & 0xff;

      key[0]='\0';
      for(i=0;i<len;i++)
	key[0] |= (pykey[i] & 0x0100) >> (8-i);

      clen=(unsigned char)len;

      fwrite(&clen,sizeof(char),1,out);
      fwrite(key,sizeof(char),len+1,out);
      fwrite(str,sizeof(char),len*2,out);

    }
  }
   
  fclose(stream);
  fclose(out);
  return (0);
}

void main(argc,argv)
     int argc;
     char **argv;
{
  if(argc != 3) {
    fprintf(stderr,"usage: %s <input_name> <output_name>\n",argv[0]);
    return;
  }
  LoadTable();
  sim2lib(argv[1],argv[2]);
  return;
}


