/*
 * Copyright (c) 2012, NVIDIA CORPORATION.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 */

/**
 * Defines the SDRAM parameter structure.
 *
 * Note that PLLM is used by EMC.
 */

#ifndef INCLUDED_NVBOOT_SDRAM_PARAM_T30_H
#define INCLUDED_NVBOOT_SDRAM_PARAM_T30_H

#define NVBOOT_BCT_SDRAM_ARB_CONFIG_WORDS 27

typedef enum {
	/* Specifies the memory type to be undefined */
	nvboot_memory_type_none = 0,

	/* Specifies the memory type to be DDR SDRAM */
	nvboot_memory_type_ddr,

	/* Specifies the memory type to be LPDDR SDRAM */
	nvboot_memory_type_lpddr,

	/* Specifies the memory type to be DDR2 SDRAM */
	nvboot_memory_type_ddr2,

	/* Specifies the memory type to be LPDDR2 SDRAM */
	nvboot_memory_type_lpddr2,

	/* Specifies the memory type to be DDR3 SDRAM */
	nvboot_memory_type_ddr3,

	nvboot_memory_type_num,
	nvboot_memory_type_force32 = 0x7FFFFFF
} nvboot_memory_type;

/**
 * Defines the SDRAM parameter structure
 */
typedef struct nvboot_sdram_params_rec {
	/* sdram data structure generated by tool warmboot_code_gen */

	/* Specifies the type of memory device */
	nvboot_memory_type memory_type;

	/* MC/EMC clock source configuration */

	/* Specifies the CPCON value for PllM */
	uint32_t pllm_charge_pump_setup_ctrl;
	/* Specifies the LPCON value for PllM */
	uint32_t pllm_loop_filter_setup_ctrl;
	/* Specifies the M value for PllM */
	uint32_t pllm_input_divider;
	/* Specifies the N value for PllM */
	uint32_t pllm_feedback_divider;
	/* Specifies the P value for PllM */
	uint32_t pllm_post_divider;
	/* Specifies the time to wait for PLLM to lock (in microseconds) */
	uint32_t pllm_stable_time;

	/* Specifies the divider for the EMC Clock Source */
	uint32_t emc_clock_divider;
	/* Specifies the PLL source for the EMC Clock Source */
	uint32_t emc_clock_source;
	/*
	 * Specifies the enable for using low jitter clock for
	 * the EMC Clock Source
	 */
	uint32_t emc_clock_use_pll_mud;

	/* Auto-calibration of EMC pads */

	/* Specifies the value for EMC_AUTO_CAL_INTERVAL */
	uint32_t emc_auto_cal_interval;
	/*
	 * Specifies the value for EMC_AUTO_CAL_CONFIG
	 * Note: Trigger bits are set by the SDRAM code.
	 */
	uint32_t emc_auto_cal_config;
	/*
	 * Specifies the time for the calibration
	 * to stabilize (in microseconds)
	 */
	uint32_t emc_auto_cal_wait;

	/*
	 * DRAM size information
	 * Specifies the value for EMC_ADR_CFG
	 */
	uint32_t emc_adr_cfg;

	/*
	 * Specifies the time to wait after asserting pin
	 * CKE (in microseconds)
	 */
	uint32_t emc_pin_program_wait;
	/* Specifies the extra delay before/after pin RESET/CKE command */
	uint32_t emc_pin_extra_wait;
	/*
	 * Specifies the extra delay after the first writing
	 * of EMC_TIMING_CONTROL
	 */
	uint32_t emc_timing_control_wait;

	/* Timing parameters required for the SDRAM */

	/* Specifies the value for EMC_RC */
	uint32_t emc_rc;
	/* Specifies the value for EMC_RFC */
	uint32_t emc_rfc;
	/* Specifies the value for EMC_RAS */
	uint32_t emc_ras;
	/* Specifies the value for EMC_RP */
	uint32_t emc_rp;
	/* Specifies the value for EMC_R2W */
	uint32_t emc_r2w;
	/* Specifies the value for EMC_R2W */
	uint32_t emc_w2r;
	/* Specifies the value for EMC_R2P */
	uint32_t emc_r2p;
	/* Specifies the value for EMC_W2P */
	uint32_t emc_w2p;
	/* Specifies the value for EMC_RD_RCD */
	uint32_t emc_rd_rcd;
	/* Specifies the value for EMC_WR_RCD */
	uint32_t emc_wr_rcd;
	/* Specifies the value for EMC_RRD */
	uint32_t emc_rrd;
	/* Specifies the value for EMC_REXT */
	uint32_t emc_rext;
	/* Specifies the value for EMC_WEXT */
	uint32_t emc_wext;
	/* Specifies the value for EMC_WDV */
	uint32_t emc_wdv;
	/* Specifies the value for EMC_QUSE */
	uint32_t emc_quse;
	/* Specifies the value for EMC_QRST */
	uint32_t emc_qrst;
	/* Specifies the value for EMC_QSAFE */
	uint32_t emc_qsafe;
	/* Specifies the value for EMC_RDV */
	uint32_t emc_rdv;
	/* Specifies the value for EMC_CTT */
	uint32_t emc_ctt;
	/* Specifies the value for EMC_CTT_DURATION */
	uint32_t emc_ctt_duration;
	/* Specifies the value for EMC_REFRESH */
	uint32_t emc_refresh;
	/* Specifies the value for EMC_BURST_REFRESH_NUM */
	uint32_t emc_burst_refresh_num;
	/* Specifies the value for EMC_PRE_REFRESH_REQ_CNT */
	uint32_t emc_prerefresh_req_cnt;
	/* Specifies the value for EMC_PDEX2WR */
	uint32_t emc_pdex2wr;
	/* Specifies the value for EMC_PDEX2RD */
	uint32_t emc_pdex2rd;
	/* Specifies the value for EMC_PCHG2PDEN */
	uint32_t emc_pchg2pden;
	/* Specifies the value for EMC_ACT2PDEN */
	uint32_t emc_act2pden;
	/* Specifies the value for EMC_AR2PDEN */
	uint32_t emc_ar2pden;
	/* Specifies the value for EMC_RW2PDEN */
	uint32_t emc_rw2pden;
	/* Specifies the value for EMC_TXSR */
	uint32_t emc_txsr;
	/* Specifies the value for EMC_TXSRDLL */
	uint32_t emc_txsr_dll;
	/* Specifies the value for EMC_TCKE */
	uint32_t emc_tcke;
	/* Specifies the value for EMC_TFAW */
	uint32_t emc_tfaw;
	/* Specifies the value for EMC_TRPAB */
	uint32_t emc_trpab;
	/* Specifies the value for EMC_TCLKSTABLE */
	uint32_t emc_tclkstable;
	/* Specifies the value for EMC_TCLKSTOP */
	uint32_t emc_tclkstop;
	/* Specifies the value for EMC_TREFBW */
	uint32_t emc_trefbw;
	/* Specifies the value for EMC_QUSE_EXTRA */
	uint32_t emc_quse_extra;

	/* FBIO configuration values */

	/* Specifies the value for EMC_FBIO_CFG5 */
	uint32_t emc_fbio_cfg5;
	/* Specifies the value for EMC_FBIO_CFG6 */
	uint32_t emc_fbio_cfg6;
	/* Specifies the value for EMC_FBIO_SPARE */
	uint32_t emc_fbio_spare;

	/* Specifies the value for EMC_CFG_RSV */
	uint32_t emc_cfg_rsv;

	/* MRS command values */

	/* Specifies the value for EMC_MRS */
	uint32_t emc_mrs;
	/* Specifies the value for EMC_EMRS */
	uint32_t emc_emrs;
	/* Specifies the programming to LPDDR2 Mode Register 1 at cold boot */
	uint32_t emc_mrw1;
	/* Specifies the programming to LPDDR2 Mode Register 2 at cold boot */
	uint32_t emc_mrw2;
	/* Specifies the programming to LPDDR2 Mode Register 3 at cold boot */
	uint32_t emc_mrw3;
	/*
	 * Specifies the programming to extra LPDDR2 Mode Register
	 * at cold boot
	 */
	uint32_t emc_mrw_extra;
	/* Specifies the programming to LPDDR2 Mode Register 1 at warm boot */
	uint32_t emc_warm_boot_mrw1;
	/* Specifies the programming to LPDDR2 Mode Register 2 at warm boot */
	uint32_t emc_warm_boot_mrw2;
	/* Specifies the programming to LPDDR2 Mode Register 3 at warm boot */
	uint32_t emc_warm_boot_mrw3;
	/*
	 * Specifies the programming to extra LPDDR2 Mode Register
	 * at warm boot
	 */
	uint32_t emc_warm_boot_mrw_extra;
	/*
	 * Specify the enable of extra Mode Register programming at
	 * warm boot
	 */
	uint32_t emc_warm_boot_extramode_reg_write_enable;
	/*
	 * Specify the enable of extra Mode Register programming at
	 * cold boot
	 */
	uint32_t emc_extramode_reg_write_enable;

	/* Specifies the EMC_MRW reset command value */
	uint32_t emc_mrw_reset_command;
	/* Specifies the EMC Reset wait time (in microseconds) */
	uint32_t emc_mrw_reset_ninit_wait;
	/* Specifies the value for EMC_MRS_WAIT_CNT */
	uint32_t emc_mrs_wait_cnt;

	/* EMC miscellaneous configurations */

	/* Specifies the value for EMC_CFG */
	uint32_t emc_cfg;
	/* Specifies the value for EMC_CFG_2 */
	uint32_t emc_cfg2;
	/* Specifies the value for EMC_DBG */
	uint32_t emc_dbg;
	/* Specifies the value for EMC_CMDQ */
	uint32_t emc_cmd_q;
	/* Specifies the value for EMC_MC2EMCQ */
	uint32_t emc_mc2emc_q;
	/* Specifies the value for EMC_DYN_SELF_REF_CONTROL */
	uint32_t emc_dyn_self_ref_control;

	/* Specifies the value for MEM_INIT_DONE */
	uint32_t ahb_arbitration_xbar_ctrl_meminit_done;

	/* Specifies the value for EMC_CFG_DIG_DLL */
	uint32_t emc_cfg_dig_dll;
	/* Specifies the value for EMC_CFG_DIG_DLL_PERIOD */
	uint32_t emc_cfg_dig_dll_period;
	/* Specifies the vlaue of *DEV_SELECTN of various EMC registers */
	uint32_t emc_dev_select;

	/* Specifies the value for EMC_SEL_DPD_CTRL */
	uint32_t emc_sel_dpd_ctrl;

	/* Pads trimmer delays */

	/* Specifies the value for EMC_DLL_XFORM_DQS0 */
	uint32_t emc_dll_xform_dqs0;
	/* Specifies the value for EMC_DLL_XFORM_DQS1 */
	uint32_t emc_dll_xform_dqs1;
	/* Specifies the value for EMC_DLL_XFORM_DQS2 */
	uint32_t emc_dll_xform_dqs2;
	/* Specifies the value for EMC_DLL_XFORM_DQS3 */
	uint32_t emc_dll_xform_dqs3;
	/* Specifies the value for EMC_DLL_XFORM_DQS4 */
	uint32_t emc_dll_xform_dqs4;
	/* Specifies the value for EMC_DLL_XFORM_DQS5 */
	uint32_t emc_dll_xform_dqs5;
	/* Specifies the value for EMC_DLL_XFORM_DQS6 */
	uint32_t emc_dll_xform_dqs6;
	/* Specifies the value for EMC_DLL_XFORM_DQS7 */
	uint32_t emc_dll_xform_dqs7;
	/* Specifies the value for EMC_DLL_XFORM_QUSE0 */
	uint32_t emc_dll_xform_quse0;
	/* Specifies the value for EMC_DLL_XFORM_QUSE1 */
	uint32_t emc_dll_xform_quse1;
	/* Specifies the value for EMC_DLL_XFORM_QUSE2 */
	uint32_t emc_dll_xform_quse2;
	/* Specifies the value for EMC_DLL_XFORM_QUSE3 */
	uint32_t emc_dll_xform_quse3;
	/* Specifies the value for EMC_DLL_XFORM_QUSE4 */
	uint32_t emc_dll_xform_quse4;
	/* Specifies the value for EMC_DLL_XFORM_QUSE5 */
	uint32_t emc_dll_xform_quse5;
	/* Specifies the value for EMC_DLL_XFORM_QUSE6 */
	uint32_t emc_dll_xform_quse6;
	/* Specifies the value for EMC_DLL_XFORM_QUSE7 */
	uint32_t emc_dll_xform_quse7;
	/* Specifies the value for EMC_DLI_TRIM_TXDQS0 */
	uint32_t emc_dli_trim_tx_dqs0;
	/* Specifies the value for EMC_DLI_TRIM_TXDQS1 */
	uint32_t emc_dli_trim_tx_dqs1;
	/* Specifies the value for EMC_DLI_TRIM_TXDQS2 */
	uint32_t emc_dli_trim_tx_dqs2;
	/* Specifies the value for EMC_DLI_TRIM_TXDQS3 */
	uint32_t emc_dli_trim_tx_dqs3;
	/* Specifies the value for EMC_DLI_TRIM_TXDQS4 */
	uint32_t emc_dli_trim_tx_dqs4;
	/* Specifies the value for EMC_DLI_TRIM_TXDQS5 */
	uint32_t emc_dli_trim_tx_dqs5;
	/* Specifies the value for EMC_DLI_TRIM_TXDQS6 */
	uint32_t emc_dli_trim_tx_dqs6;
	/* Specifies the value for EMC_DLI_TRIM_TXDQS7 */
	uint32_t emc_dli_trim_tx_dqs7;
	/* Specifies the value for EMC_DLL_XFORM_DQ0 */
	uint32_t emc_dll_xform_dq0;
	/* Specifies the value for EMC_DLL_XFORM_DQ1 */
	uint32_t emc_dll_xform_dq1;
	/* Specifies the value for EMC_DLL_XFORM_DQ2 */
	uint32_t emc_dll_xform_dq2;
	/* Specifies the value for EMC_DLL_XFORM_DQ3 */
	uint32_t emc_dll_xform_dq3;

	/*
	 * Specifies the delay after asserting CKE pin during a WarmBoot0
	 * sequence (in microseconds)
	 */
	uint32_t warm_boot_wait;

	/* Specifies the value for EMC_CTT_TERM_CTRL */
	uint32_t emc_ctt_term_ctrl;

	/* Specifies the value for EMC_ODT_WRITE */
	uint32_t emc_odt_write;
	/* Specifies the value for EMC_ODT_WRITE */
	uint32_t emc_odt_read;

	/* Periodic ZQ calibration */

	/*
	 * Specifies the value for EMC_ZCAL_INTERVAL
	 * Value 0 disables ZQ calibration
	 */
	uint32_t emc_zcal_interval;
	/* Specifies the value for EMC_ZCAL_WAIT_CNT */
	uint32_t emc_zcal_wait_cnt;
	/* Specifies the value for EMC_ZCAL_MRW_CMD */
	uint32_t emc_zcal_mrw_cmd;

	/* DRAM initialization sequence flow control */

	/* Specifies the MRS command value for resetting DLL */
	uint32_t emc_mrs_reset_dll;
	/* Specifies the command for ZQ initialization of device 0 */
	uint32_t emc_zcal_init_dev0;
	/* Specifies the command for ZQ initialization of device 1 */
	uint32_t emc_zcal_init_dev1;
	/*
	 * Specifies the wait time after programming a ZQ initialization
	 * command (in microseconds)
	 */
	uint32_t emc_zcal_init_wait;
	/* Specifies the enable for ZQ calibration at cold boot */
	uint32_t emc_zcal_cold_boot_enable;
	/* Specifies the enable for ZQ calibration at warm boot */
	uint32_t emc_zcal_warm_boot_enable;

	/*
	 * Specifies the MRW command to LPDDR2 for ZQ calibration
	 *on warmboot
	 */
	/* Is issued to both devices separately */
	uint32_t emc_mrw_lpddr2zcal_warm_boot;
	/*
	 * Specifies the ZQ command to DDR3 for ZQ calibration on warmboot
	 * Is issued to both devices separately
	 */
	uint32_t emc_zqcal_ddr3_warm_boot;
	/*
	 * Specifies the wait time for ZQ calibration on warmboot
	 * (in microseconds)
	 */
	uint32_t emc_zcal_warm_boot_wait;
	/*
	 * Specifies the enable for DRAM Mode Register programming
	 * at warm boot
	 */
	uint32_t emc_mrs_warm_boot_enable;
	/*
	 * Specifies the wait time after sending an MRS DLL reset command
	 * in microseconds)
	 */
	uint32_t emc_mrs_reset_dll_wait;
	/*
	 * Specifies the first of two EMRS commands to initialize mode
	 * registers
	 */
	uint32_t emc_emrs_emr2;
	/*
	 * Specifies the second of two EMRS commands to initialize mode
	 * registers
	 */
	uint32_t emc_emrs_emr3;
	/* Specifies the extra MRS command to initialize mode registers */
	uint32_t emc_mrs_extra;
	/* Specifies the programming to DDR3 Mode Register 0 at warm boot */
	uint32_t emc_warm_boot_mrs;
	/* Specifies the programming to DDR3 Mode Register 1 at warm boot */
	uint32_t emc_warm_boot_emrs;
	/* Specifies the programming to DDR3 Mode Register 2 at warm boot */
	uint32_t emc_warm_boot_emr2;
	/* Specifies the programming to DDR3 Mode Register 3 at warm boot */
	uint32_t emc_warm_boot_emr3;
	/* Specifies the extra MRS command at warm boot */
	uint32_t emc_warm_boot_mrs_extra;
	/* Specifies the EMRS command to enable the DDR2 DLL */
	uint32_t emc_emrs_ddr2_dll_enable;
	/* Specifies the MRS command to reset the DDR2 DLL */
	uint32_t emc_mrs_ddr2_dll_reset;
	/* Specifies the EMRS command to set OCD calibration */
	uint32_t emc_emrs_ddr2_ocd_calib;
	/*
	 * Specifies the wait between initializing DDR and setting OCD
	 * calibration (in microseconds)
	 */
	uint32_t emc_ddr2_wait;
	/* Specifies the value for EMC_CLKEN_OVERRIDE */
	uint32_t emc_clken_override;
	/*
	 * Specifies LOG2 of the extra refresh numbers after booting
	 * Program 0 to disable
	 */
	uint32_t emc_extra_refresh_num;
	/* Specifies the master override for all EMC clocks */
	uint32_t emc_clken_override_allwarm_boot;
	/* Specifies the master override for all MC clocks */
	uint32_t mc_clken_override_allwarm_boot;
	/* Specifies digital dll period, choosing between 4 to 64 ms */
	uint32_t emc_cfg_dig_dll_period_warm_boot;

	/* Pad controls */

	/* Specifies the value for PMC_VDDP_SEL */
	uint32_t pmc_vddp_sel;
	/* Specifies the value for PMC_DDR_PWR */
	uint32_t pmc_ddr_pwr;
	/* Specifies the value for PMC_DDR_CFG */
	uint32_t pmc_ddr_cfg;
	/* Specifies the value for PMC_IO_DPD_REQ */
	uint32_t pmc_io_dpd_req;
	/* Specifies the value for PMC_E_NO_VTTGEN */
	uint32_t pmc_eno_vtt_gen;
	/* Specifies the value for PMC_NO_IOPOWER */
	uint32_t pmc_no_io_power;
	/* Specifies the value for EMC_XM2CMDPADCTRL */
	uint32_t emc_xm2cmd_pad_ctrl;
	/* Specifies the value for EMC_XM2CMDPADCTRL2 */
	uint32_t emc_xm2cmd_pad_ctrl2;
	/* Specifies the value for EMC_XM2DQSPADCTRL */
	uint32_t emc_xm2dqs_pad_ctrl;
	/* Specifies the value for EMC_XM2DQSPADCTRL2 */
	uint32_t emc_xm2dqs_pad_ctrl2;
	/* Specifies the value for EMC_XM2DQSPADCTRL3 */
	uint32_t emc_xm2dqs_pad_ctrl3;
	/* Specifies the value for EMC_XM2DQPADCTRL */
	uint32_t emc_xm2dq_pad_ctrl;
	/* Specifies the value for EMC_XM2DQPADCTRL2 */
	uint32_t emc_xm2dq_pad_ctrl2;
	/* Specifies the value for EMC_XM2CLKPADCTRL */
	uint32_t emc_xm2clk_pad_ctrl;
	/* Specifies the value for EMC_XM2COMPPADCTRL */
	uint32_t emc_xm2comp_pad_ctrl;
	/* Specifies the value for EMC_XM2VTTGENPADCTRL */
	uint32_t emc_xm2vttgen_pad_ctrl;
	/* Specifies the value for EMC_XM2VTTGENPADCTRL2 */
	uint32_t emc_xm2vttgen_pad_ctrl2;
	/* Specifies the value for EMC_XM2QUSEPADCTRL */
	uint32_t emc_xm2quse_pad_ctrl;

	/* DRAM size information */

	/* Specifies the value for MC_EMEM_ADR_CFG */
	uint32_t mc_emem_adr_cfg;
	/* Specifies the value for MC_EMEM_ADR_CFG_DEV0 */
	uint32_t mc_emem_adr_cfg_dev0;
	/* Specifies the value for MC_EMEM_ADR_CFG_DEV1 */
	uint32_t mc_emem_adr_cfg_dev1;

	/*
	 * Specifies the value for MC_EMEM_CFG which holds the external memory
	 * size (in KBytes)
	 */
	uint32_t mc_emem_cfg;

	/* MC arbitration configuration */

	/* Specifies the value for MC_EMEM_ARB_CFG */
	uint32_t mc_emem_arb_cfg;
	/* Specifies the value for MC_EMEM_ARB_OUTSTANDING_REQ */
	uint32_t mc_emem_arb_outstanding_req;
	/* Specifies the value for MC_EMEM_ARB_TIMING_RCD */
	uint32_t mc_emem_arb_timing_rcd;
	/* Specifies the value for MC_EMEM_ARB_TIMING_RP */
	uint32_t mc_emem_arb_timing_rp;
	/* Specifies the value for MC_EMEM_ARB_TIMING_RC */
	uint32_t mc_emem_arb_timing_rc;
	/* Specifies the value for MC_EMEM_ARB_TIMING_RAS */
	uint32_t mc_emem_arb_timing_ras;
	/* Specifies the value for MC_EMEM_ARB_TIMING_FAW */
	uint32_t mc_emem_arb_timing_faw;
	/* Specifies the value for MC_EMEM_ARB_TIMING_RRD */
	uint32_t mc_emem_arb_timing_rrd;
	/* Specifies the value for MC_EMEM_ARB_TIMING_RAP2PRE */
	uint32_t mc_emem_arb_timing_rap2pre;
	/* Specifies the value for MC_EMEM_ARB_TIMING_WAP2PRE */
	uint32_t mc_emem_arb_timing_wap2pre;
	/* Specifies the value for MC_EMEM_ARB_TIMING_R2R */
	uint32_t mc_emem_arb_timing_r2r;
	/* Specifies the value for MC_EMEM_ARB_TIMING_W2W */
	uint32_t mc_emem_arb_timing_w2w;
	/* Specifies the value for MC_EMEM_ARB_TIMING_R2W */
	uint32_t mc_emem_arb_timing_r2w;
	/* Specifies the value for MC_EMEM_ARB_TIMING_W2R */
	uint32_t mc_emem_arb_timing_w2r;
	/* Specifies the value for MC_EMEM_ARB_DA_TURNS */
	uint32_t mc_emem_arb_da_turns;
	/* Specifies the value for MC_EMEM_ARB_DA_COVERS */
	uint32_t mc_emem_arb_da_covers;
	/* Specifies the value for MC_EMEM_ARB_MISC0 */
	uint32_t mc_emem_arb_misc0;
	/* Specifies the value for MC_EMEM_ARB_MISC1 */
	uint32_t mc_emem_arb_misc1;
	/* Specifies the value for MC_EMEM_ARB_RING1_THROTTLE */
	uint32_t mc_emem_arb_ring1_throttle;
	/* Specifies the value for MC_EMEM_ARB_OVERRIDE */
	uint32_t mc_emem_arb_override;
	/* Specifies the value for MC_EMEM_ARB_RSV */
	uint32_t mc_emem_arb_rsv;

	/* Specifies the value for MC_CLKEN_OVERRIDE */
	uint32_t mc_clken_override;

	/* End of generated code by warmboot_code_gen */
} nvboot_sdram_params;
#endif /* #ifndef INCLUDED_NVBOOT_SDRAM_PARAM_T30_H */

