;;; Boot sector for the C128 that loads the prserver daemon automatically
;;; and switches the PIA memory expansion off (if present) when required.
;;; To use this, copy the 256 bytes to track 1, sector 0 of drive 8 e.g. with
;;; cbmlink ... -dw bootsect.bin

;;; Copyright  1996,2001,2002 Marko Mkel (msmakela@nic.funet.fi)
;;; Converted from DASM to XA syntax in 2002.

	.text
	*=$b00	; the whole code must fit in $b00-$bff

	.byt "CBM"		; magic cookie
	.byt 0,0,0,0		; no other boot sector
	.byt "CBMLINK",0	; program title
	.byt 0			; no filename

	;; base address for the internal 512kB/1 MB PIA memory expansion
pia = 0				; 0=none, or e.g. $d7c0
	;; default start-up mode
default = 0
	;; code			also activated when these keys are pressed
	;; 0 to 3, 8 to 15	(none) <- 1 2
	;;	C128 mode, PIA not disabled
	;; 4 to 7		Control
	;;	C128 mode, PIA disabled
	;; 16 to 31		Space
	;;	C64 mode, PIA disabled, drive forced to 1541 mode
	;; 32 to 63		C=
	;;	C64 mode, PIA not disabled
	;; 64 to 127		Q
	;;	nothing loaded, C64 mode
	;; 128 to 255		Stop
	;;	nothing loaded, C128 mode

;;; some KERNAL entries
setmsg	= $ff90
setlfs	= $ffba
setnam	= $ffbd
open	= $ffc0
close	= $ffc3
load	= $ffd5

la	= $b8		; current logical file number
sa	= $b9		; current secondary address
fa	= $ba		; current device number
sal	= $ac		; start address of the last file loaded (C128 only)
sah	= $ad

entry:	lda #$c0
	jsr setmsg	; enable system messages
	lda $dc01	; check STOP, Q, C=, space, 2, CTRL, <- and 1
	eor #$ff
	bne nodefault
	lda #default	; no key pressed => use the default value
nodefault:
	bpl noexit
abort1: rts		; STOP pressed => exit to normal 128 mode
noexit:
	cmp #$40	; Q key => switch to C64 mode, do not load anything
	bcs force1541

	cmp #$20
	bcc cont	; C= key => switch to C64 or C2564 mode

#if pia
	ldx #<file2564
	lda #f2564end-file2564
#else
	ldx #<file64
	lda #f64end-file64
#endif
	jsr loadf
	bcs abort1
	lda sal		; prepare for jump at start address
	sta jump+1
	lda sah
	sta jump+2
	lda #$f1
	bne c64mode	; branch always

cont:
	cmp #$10	; space bar => disable the PIA and switch to C64 mode
	bcc c128mode

#if pia
	jsr piaoff	; shut off the PIA expansion
#endif
	ldx #<file64
	lda #f64end-file64
	jsr loadf
	bcs abort

	lda sal		; prepare for jump at start address
	sta jump+1
	lda sah
	sta jump+2

force1541:
	ldx fa		; reset the drive (force 1541 mode)
	lda #15
	tay
	jsr setlfs
	lda #ini1571e-init1571
	ldx #<init1571
	ldy #>init1571
	jsr setnam
	jsr open
	jsr close

	lda #$71	; prepare for disabling the 40/80 key sense line
c64mode:
	sei		; switch to C64 mode
	ldx #$ff
	stx $d02f
	inx
	stx $d030
	stx $d506
	sta $d505
	lda #$37
	sta 1

	ldx #$ff
	txs
	jsr $fda3	; this is copied from the C64 reset routine
	jsr $fd50
	jsr $fd15
	jsr $ff5b

jump:	jsr abort	; placeholder for self-modifying code => init cbmlink

	cli
	jmp ($a000)

init1571:
	.byt "U0>M0"
ini1571e:

c128mode:
#if pia
	and #4		; CTRL key: shut off the PIA expansion
	beq skip
	jsr piaoff
	ldx #<file128
	lda #f128end-file128
	bne launch	; branch always
skip:
	ldx #<file1028
	lda #f1028end-file1028
#else
	ldx #<file128
	lda #f128end-file128
#endif

launch:
	jsr loadf
	bcs abort
	jmp (sal)	; launch the program
abort:	rts

#if pia
piaoff:	ldx #11
loop:	lda piatable,x
	sta pia+1,x
	dex
	bpl loop
	rts

piatable:
	.byt $35,$fe,4,$ff,0,$ff,0,$dc,4,$fe,4
#endif

loadf:	ldy #>file64
	jsr setnam	; set the file name,
	lda #1
	sta la		; file number and
	sta sa		; secondary address.
	lda #0
	jmp load	; load the file

;file names

file64:
	.byt "CBM64"
f64end:

file128:
	.byt "CBM128"
f128end:

#if pia
file2564:
	.byt "CBM2564"
f2564end:

file1028:
	.byt "CBM1028"
f1028end:
#endif

	.dsb $c00-*, $ff
