/***************************************************************************
 *   Copyright (C) 2004-2010 by Pere Constans
 *   constans@molspaces.com
 *   cb2Bib version 1.4.0. Licensed under the GNU GPL version 3.
 *   See the LICENSE file that comes with this distribution.
 ***************************************************************************/
#include "c2bClipboard.h"
#ifdef CB_POLL
#include "clipboardPoll.h"
#endif

#include <QApplication>


c2bClipboard::c2bClipboard(QObject* parento) : QObject(parento)
{
    // Connecting clipboard
    _cb = QApplication::clipboard();
    _supports_selection = _cb->supportsSelection();
    _is_connected = false;
    _cb_text = _cb->text(QClipboard::Clipboard);
    if (_supports_selection)
        _cbs_text = _cb->text(QClipboard::Selection);

    // Setting timer
    _interval = 1000;
    // Uncomment the 4 timer-related lines if clipboard appears unresponsive
    // and it cannot be compiled with cbpoll option
    _timer = 0;
//    _timer = new QTimer(this);
//    connect(_timer, SIGNAL(timeout()), this, SLOT(checkData()));

#ifdef CB_POLL
    _poll = new clipboardPoll();
    connect(_poll, SIGNAL(clipboardChanged(bool)), this, SLOT(newClipboardData(bool)));
#endif
}

c2bClipboard::~c2bClipboard()
{
#ifdef CB_POLL
    delete _poll;
#endif
}


void c2bClipboard::checkData()
{
    if (_supports_selection)
    {
        if (_cb_text != _cb->text(QClipboard::Clipboard))
        {
            _cb_text = _cb->text(QClipboard::Clipboard);
            _cbs_text = _cb->text(QClipboard::Selection);
            emit cbDataChanged(_cb_text);
        }
        else if (_cbs_text != _cb->text(QClipboard::Selection))
        {
            _cbs_text = _cb->text(QClipboard::Selection);
            emit cbDataChanged(_cbs_text);
        }
    }
    else
    {
        if (_cb_text != _cb->text(QClipboard::Clipboard))
        {
            _cb_text == _cb->text(QClipboard::Clipboard);
            emit cbDataChanged(_cb_text);
        }
    }
}

void c2bClipboard::dataChanged()
{
    _cb_text = _cb->text(QClipboard::Clipboard);
    emit cbDataChanged(_cb_text);
}

void c2bClipboard::selectionChanged()
{
    _cbs_text = _cb->text(QClipboard::Selection);
    emit cbDataChanged(_cbs_text);
}

void c2bClipboard::setConnected(bool zconn)
{
    _is_connected = zconn;
    if (_is_connected)
    {
        _cb_text = _cb->text(QClipboard::Clipboard);
        connect(_cb, SIGNAL(dataChanged()), this, SLOT(dataChanged()));
        if (_supports_selection)
        {
            _cbs_text = _cb->text(QClipboard::Selection);
            connect(_cb, SIGNAL(selectionChanged()), this, SLOT(selectionChanged()));
        }
#ifdef CB_POLL
        _poll->startT(_interval);
#endif
//        _timer->start(_interval);
    }
    else
    {
#ifdef CB_POLL
        _poll->stopT();
#endif
//        _timer->stop();
        disconnect(_cb, SIGNAL(dataChanged()), this, SLOT(dataChanged()));
        if (_supports_selection)
            disconnect(_cb, SIGNAL(selectionChanged()), this, SLOT(selectionChanged()));
    }
}

const QString c2bClipboard::text()
{
    return _cb->text(QClipboard::Clipboard);
}

void c2bClipboard::newClipboardData(bool selectionMode)
{
    if (selectionMode)
        checkSelectionData();
    else
        checkClipboardData();
}

void c2bClipboard::checkSelectionData()
{
    if (_supports_selection)
        if (_cbs_text != _cb->text(QClipboard::Selection))
        {
            _cbs_text = _cb->text(QClipboard::Selection);
            emit cbDataChanged(_cbs_text);
        }
}

void c2bClipboard::checkClipboardData()
{
    if (_cb_text != _cb->text(QClipboard::Clipboard))
    {
        _cb_text = _cb->text(QClipboard::Clipboard);
        emit cbDataChanged(_cb_text);
    }
}
