#ifndef VIDEODEVICEINPUT_HPP
#define VIDEODEVICEINPUT_HPP

#include <qobject.h>
#include <qvector.h>

#include "VideoDeviceTuner.h"

class CVideoDevice;

class CVideoDeviceInput: public QObject
{
   Q_OBJECT
private:
   CVideoDevice *pVideo;
   int Channel;
   QVector <CVideoDeviceTuner>Tuners;
   int CurrentTuner;

   QString Name;
   int Type;

   int flags, Norm;

public:
   enum {
     Unknown,
     TV,
     Camera
   } InputTypes;
   enum {
     PAL,
     NTSC,
     SECAM,
     PAL_NC,
     PAL_M,
     PAL_N,
     NTSC_JAPAN,
     MAX,
   } TunerNorms;

   CVideoDeviceInput(CVideoDevice *video, int channel);

   int GetNumber() const;   
   QString GetName() const;
   bool HasAudio() const;
   int GetType() const;
   
   int GetTuners() const;
   int GetCurrentTuner() const;
   CVideoDeviceTuner *GetTuner(int number) const;
   bool SelectTuner(int number);
   void SetNorm(int norm);
   
   bool Select();
};


#endif
