/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#include "DevWindow.h"

#include <QString>
#include <QFileDialog>
#include <QMessageBox>
#include<iostream>

#include "ExtensionGenerator.h"

DevWindow::DevWindow(QMainWindow * dad) : QMainWindow(dad)
{
    ui.setupUi(this);
    this->dad = dad;
    this->devDirectory = "";
    this->xmlFile = "";
}

void DevWindow::okClicked() {
    devDirectory = ui.devDirLineEdit->text();
    xmlFile = ui.xmlFileLineEdit->text();

    if (devDirectory == "") {
        QMessageBox::warning(this, tr("Before going further..."), tr("Please set the development directory\n"));
        return;
    }
    if (xmlFile == "") {
        QMessageBox::warning(this, tr("Before going further..."), tr("Please set the xml extension file name\n"));
        return;
    }

    if (! ExtensionGenerator::generateExtensionFiles(xmlFile, devDirectory)) {
        QMessageBox::warning(this, tr("Extension generation"), tr("The extension could not be generated correctly, sorry...\n"));
    }   

    this->close();
}
void DevWindow::cancelClicked() {
    this->close();
    dad->show();
}

void DevWindow::devDirToolButtonClicked() {
    QString fileName = QFileDialog::getExistingDirectory( this, tr("Set the development directory"), devDirectory);
    ui.devDirLineEdit->setText(fileName);
}

void DevWindow::xmlFileToolButtonClicked() {
    QString fileName = QFileDialog::getOpenFileName(this, tr("Choose the extension xml file"), xmlFile, "File (*.xml)");
    ui.xmlFileLineEdit->setText(fileName);
}
