/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "DecimationWidget.h"
#include "ui_DecimationWidget.h"
#include "Decimation.h"

//--------------- Constructor ---------------------
DecimationWidget::DecimationWidget(Decimation*myAction) : QWidget() {
    this->myAction = myAction;
    ui = new Ui::ui_DecimationWidget;
    ui->setupUi(this);
}

//--------------- Destructor -----------------------
DecimationWidget::~DecimationWidget() {
    delete ui;
}

//--------------- update ------------------
void DecimationWidget::updateTargets() {
    // not needed in this case, but this is also to show a pedagogical example
    ui->checkBox_preserveTopology->setChecked(myAction->property("preserveTopology").toBool());
    ui->percentageOfDecimation->setValue(myAction->property("percentageOfReduction").toDouble());
    ui->editDetailsCheckBox->setChecked(myAction->property("setDetails").toBool());
    ui->lineMaxError->setText(myAction->property("maxError").toString());
    ui->lineFeatureAngle->setText(myAction->property("featureAngle").toString());
    ui->checkBox_Splitting->setChecked(myAction->property("splitting").toBool());
    ui->lineSplittingAngle->setText(myAction->property("splitAngle").toString());
    ui->checkBox_BoundaryDeletion->setChecked( myAction->property("boundaryDeletion").toBool());
    ui->lineDegree->setText(myAction->property("degree").toString());
    ui->lineInflectionRatio->setText(myAction->property("inflectionRatio").toString());
}

// -------------------- on_editDetailsCheckBox_toggled --------------------
void DecimationWidget::on_editDetailsCheckBox_toggled(bool toggled) {
    ui->groupBox_Details->setEnabled(toggled);
}

//--------------- on_applyButton_clicked ------------------
void DecimationWidget::on_applyButton_clicked() {
    myAction->setProperty("preserveTopology", ui->checkBox_preserveTopology->isChecked());
    myAction->setProperty("percentageOfReduction", ui->percentageOfDecimation->value());
    myAction->setProperty("setDetails", ui->editDetailsCheckBox->isChecked());
    myAction->setProperty("maxError", ui->lineMaxError->text().toDouble());
    myAction->setProperty("featureAngle", ui->lineFeatureAngle->text().toDouble());
    myAction->setProperty("splitting", ui->checkBox_Splitting->isChecked());
    myAction->setProperty("splitAngle", ui->lineSplittingAngle->text().toDouble());
    myAction->setProperty("boundaryDeletion", ui->checkBox_BoundaryDeletion->isChecked());
    myAction->setProperty("degree", ui->lineDegree->text().toInt());
    myAction->setProperty("inflectionRatio", ui->lineInflectionRatio->text().toDouble());

    myAction->apply();
}

//--------------- on_cancelButton_clicked ------------------
void DecimationWidget::on_cancelButton_clicked() {
    hide();
}


