/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#include "StructuralComponentDCPopup.h"
#include "StructuralComponentDC.h"

#include <pml/StructuralComponent.h>
#include <pml/Atom.h>

#include <Component.h>

#include <QFileDialog>
#include <QMessageBox>

// ---------------------- constructor ----------------------------
StructuralComponentDCPopup::StructuralComponentDCPopup(camitk::Component *dc, QWidget *parent) : camitk::ComponentPopupMenu(dc, parent) {

  addAction("Export To CSV...", SLOT(saveToCsv()));
}

/* TODO : translate this to CamiTK 3.0 action on StructuralComponentDC
// ---------------------- vtkExport ----------------------------
void StructuralComponentDCPopup::vtkExport() {
  vtkSmartPointer<vtkPointSet> representation = myComponent->getPointSet();
  if (representation == NULL) {
    // try harder
    dynamic_cast<StructuralComponentDC *>(myComponent)->updateAtoms();
    Geometry *g = dynamic_cast<StructuralComponentDC *>(myComponent)->cellsToGeometry();
    if (g==NULL) {
        QMessageBox::warning(0, "Cannot export to VTK", "This StructuralComponent cannot be exported to VTK:\nit does not have any geometric representation");
        return;
    }
    else {
        representation = g->getPointSet();
    }
  }
  
  QDir lastOpenedDirectory = QFileInfo(myComponent->getFileName()).absoluteDir();
  QString vtkFileName = QFileDialog::getSaveFileName(NULL, "Import VTK File...", lastOpenedDirectory.absolutePath(), tr("Vtk (*.vtk)"));
  
  VtkMeshUtil::savePointSetToFile(representation, vtkFileName.toStdString(), myComponent->getName().toStdString());
  
}
*/

//------------------------saveToCsv()---------------------
void StructuralComponentDCPopup::saveToCsv(){
  QDir lastOpenedDirectory;
  lastOpenedDirectory = QFileInfo(myComponent->getTopLevelComponent()->getFileName()).absoluteDir();

  // get the file name
  QString newFileName = QFileDialog::getSaveFileName(NULL, "Save to CSV (Space Separated Values)...", lastOpenedDirectory.absolutePath(), tr("csv (*.csv)"));

  // get the file name
  if (!newFileName.isNull()) {
    std::ofstream out;
    out.open(newFileName.toStdString().c_str());

    if (!out.is_open()) {
      return;
    }

    StructuralComponent * theAtoms = dynamic_cast<StructuralComponentDC *>(myComponent)->getSC()->getAtoms();

    Atom *a;
    double pos[3];

    out << "Ref CoordX CoordY CoordZ" << std::endl;
    for (unsigned int i = 0;i < theAtoms->getNumberOfStructures();i++) {
      // write the  position
      a = (Atom *) theAtoms->getStructure(i);
      unsigned int ind = a->getIndex();
      out << ind << " ";
      a->getPosition(pos);
      out << pos[0] << " " << pos[1] << " " << pos[2] << std::endl;
    }

    out << std::endl;

    out.close();
  }
}



