/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2014 UJF-Grenoble 1, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/

#ifndef CELLDCPROPERTIES_H
#define CELLDCPROPERTIES_H

#include <QObject>
class CellDC;
/**
 *  @ingroup group_cepmodeling_components_physicalmodel
 *  
 * @brief
 *  The class CellDCProperties defines an QObject that allows user interaction
 *  with properties of a cell (in an automatically generated UI)
 *
 *  The default cell properties are created thanks to Q_PROPERTY.
 *  The extra properties found in the PML document are also available thanks
 *  to the dynamic features of the Qt's Property System (see qt documentation).
 * 
 * 
 **/
class CellDCProperties : public QObject  {
  Q_OBJECT

  /** the index property that will be managed in the property dialog */
  Q_PROPERTY( QString name READ getName WRITE setName )

  /// the geometric type property
  Q_PROPERTY( GeometricType geometry READ getGeometry )

  /// the Qt property enum has to be build from the C++ enum GeometricType
  Q_ENUMS( GeometricType )

public:

  /** Default construtor */
  CellDCProperties(CellDC *);
  ~CellDCProperties() {}

  /// change the currently managed CellDC and update the value of the properties
  void updateProperties(CellDC*);

  /** Set and get method for all the properties */
    /// change the cell's name (if name is not an index)
  void setName( const QString );

  /// get the atom's index in a form the property editor understands
  QString getName() const;

  /// this is a copy of StructureProperties::GeometricType, I tried to reuse it but it generated crashes...
  enum GeometricType { INVALID, ATOM, TETRAHEDRON, HEXAHEDRON, WEDGE, PYRAMID, LINE, POLY_LINE, POLY_VERTEX, TRIANGLE, QUAD };

  /// get the geometric type
  GeometricType getGeometry() const;

  /** intercept signal for dynamic property changed. */
  virtual bool event(QEvent* e);

private:

  /// the currently selected CellDC
  CellDC *myDC;

};

#endif

