(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

module D = Omom_data
module T = Omom_templates
module M = Omom_messages
module C = Configwin
module GT = Omom_gui_templates

class gui (data : D.data) =
object(self)
  inherit Omom_gui_base.main ()

    val data = data

    val mutable templates = None 

    method set_templates tpl =
      templates <- Some tpl

    method templates =
      match templates with
	| Some tpl -> tpl
	| None -> failwith "class gui: templates uninitialized"
	    
    method add_template () =
      let s1 = ref None 
      and s2 = ref None in
      let p1 =
	C.string ~f:(fun s -> s1 := Some s) M.new_template_name ""
      and p2 =
	C.filename ~f:(fun s -> s2 := Some s) M.new_template_filename "" in
	match C.simple_get M.new_template_title [p1; p2] with
	  | C.Return_ok ->
	      (match (!s1, !s2) with
		 | Some tpl_name, Some tpl_file ->
		    self#templates#add_template tpl_name tpl_file
		 | _ ->
		     ())
	  | _ ->
	      ()

    method quit () =
      if self#changed then
	match GToolbox.question_box
	  ~title: M.save_or_not ~buttons: [M.yes; M.no; M.cancel] ~default:1 M.save_or_not with
	    | 1 ->
		data#save;
		box#destroy ()
	    | 3 ->
		()
	    | _ ->
		box#destroy ()
      else 
	box#destroy ()

    method save () =
      self#templates#save

    method changed =
      self#templates#changed

    initializer
      self#set_templates (new GT.box_templates wnote data);

      ignore (itemQuit#connect#activate self#quit);
      ignore (itemAbout#connect#activate
		(fun () -> GToolbox.message_box M.software
		   M.software_about));
      ignore (itemNewTemplate#connect#activate self#add_template);
      ignore (itemSave#connect#activate self#save);
      ignore (itemRemoveTemplate#connect#activate self#templates#remove_template);
      ignore (itemAddField#connect#activate self#templates#add_field);
      ignore (itemRemoveField#connect#activate self#templates#remove_field);
      ignore (itemRenameField#connect#activate self#templates#rename_field);
      ignore (itemTemplateProperties#connect#activate
		self#templates#edit_properties)
end
