(**************************************************************************)
(*                   Cameleon                                             *)
(*                                                                        *)
(*      Copyright (C) 2002 Institut National de Recherche en Informatique et   *)
(*      en Automatique. All rights reserved.                              *)
(*                                                                        *)
(*      This program is free software; you can redistribute it and/or modify  *)
(*      it under the terms of the GNU General Public License as published by  *)
(*      the Free Software Foundation; either version 2 of the License, or  *)
(*      any later version.                                                *)
(*                                                                        *)
(*      This program is distributed in the hope that it will be useful,   *)
(*      but WITHOUT ANY WARRANTY; without even the implied warranty of    *)
(*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the     *)
(*      GNU General Public License for more details.                      *)
(*                                                                        *)
(*      You should have received a copy of the GNU General Public License  *)
(*      along with this program; if not, write to the Free Software       *)
(*      Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA          *)
(*      02111-1307  USA                                                   *)
(*                                                                        *)
(*      Contact: Maxence.Guesdon@inria.fr                                *)
(**************************************************************************)

(** Main module *)

let host = ref "localhost"
let port = ref 5036
let id = ref "Chat_say"

let message = ref ([] : string list)

let options = [
  "-h", Arg.String (fun h -> host := h), "<host>  connect to mlchat on host <host>" ;
  "-p", Arg.Int (fun p -> port := p), "<port>  connect to mlchat using port <port>"; 
  "-i", Arg.String (fun s -> id := s), "<id>  connect to mlchat with id <id>";
] 

let main () =
  Arg.parse options
    (fun s -> message := s :: !message)
    ("Usage : "^Sys.argv.(0)^" [options] <message>\nWhere [options] are:");
    
  match List.rev !message with
    [] -> ()
  | l ->
      try
	let domain = Unix.PF_INET in
	let ip =
	  let h = Unix.gethostbyname !host in
	  h.Unix.h_addr_list.(0)
	in
	let sockaddr = Unix.ADDR_INET (ip, !port) in
	let f mes =
	  let sock = Unix.socket domain Unix.SOCK_STREAM 0 in
	  let chanout = Unix.out_channel_of_descr sock in
	  let source = (Chat_messages.software_version, !id, 
			(Unix.gethostname (), 0))
	  in
	  let info = (source, "", (Chat_proto.Message mes)) in
	  Unix.connect sock sockaddr;
	  Chat_proto.write_info_channel chanout info;
	  flush chanout;
	  close_out chanout;
	in
	List.iter f l;
	exit 0
      with
      | Unix.Unix_error (e,s1,s2) ->
	  let s = s1^" "^s2^" : "^(Unix.error_message e) in
	  prerr_endline s;
	  exit 1
;;

main ()
