Name: camE
Version: 1.3
Release: 1
Source: %{name}-%{version}.tar.gz
License: OpenSource
Url: http://www.linuxbrit.co.uk/
Vendor: Tom Gilbert <tom@linuxbrit.co.uk>
Packager: Janus N. Tndering <janus@bananus.dk>
Group: Applications/Multimedia
Summary: rewrite of the xawtv webcam with numerous new features

BuildRoot: /tmp/%{name}-build
Requires: giblib
BuildRequires: giblib-devel

%description
camE is a rewrite of the xawtv webcam app, which adds 
imlib2 support and there following new features:
    * ttf fonts
    * blended transparent text
    * title text
    * options in ~/.camErc
    * message read from separate file 
		  (eg echo "eating my dinner" > ~/.caminfo)
    * color the text as you like
    * text background any color/alpha value
    * scp support for uploading
    * ftp support for uploading using libcurl, reconnect 
		  for each upload or reuse one connection
    * proper logging to file
    * user defined actions to be run before and after shots, 
		  and after upload (use to play sounds, beep, run scripts, 
			copy files, whatever)
    * file for stopping uploads temporarily 
		  (touch ~/BLOCKCAM to stop shooting, remove it to resume)
    * now a proper daemon that can run without X forever if wanted
    * control of brightness, contrast, gamma, hue, colour, etc
    * control of framerate and use of snapshot mode for Philips cams
    * image archiving (timestamped into a directory of your choice 
		  after upload), every frame or every n frames
    * lag reduction (for some cams, when mmaped, the image 
		  grabbed lags behind the cam by up to 20 seconds. I use 
			lag_reduce 5 in my ~/.camErc for example. This takes 
			5 shots in a row, which clears the mmap buffers, and 
			then keeps the last shot, lag-free)
    * Other stuff I can't remember

%prep
%setup

%build
make

%install
make -e ROOT=$RPM_BUILD_ROOT prefix=/usr install

%clean
[ "$RPM_BUILD_ROOT" != "/" ] && rm -fR $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc AUTHORS COPYING camE_text.style camE_title.style 
%doc example.camErc.ssh example.camErc
/usr/bin/camE

