/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: camas_preferences_files.pike,v 1.3.2.1 2004/03/19 10:09:04 vida Exp $
 */

#include <module.h>
#include <camas/globals.h>
inherit "module";

constant cvs_version="$Id: camas_preferences_files.pike,v 1.3.2.1 2004/03/19 10:09:04 vida Exp $";
constant module_type = MODULE_PROVIDER;
constant module_name = "CAMAS: Preferences Files";
constant module_doc  = "Files preferences module for CAMAS. This module will take care of retrieving "
                       "and storing preferences from a per user file for other CAMAS modules.<br/>"
                       "<i>Note</i>: If you load several preferences modules, Camas will store "
                       "information on each of them allowing you to migrate easily among them. "
                       "It will also try to load the preferences for each of them in the order of "
                       "the priority of each module. In this mode, it will stop after the first successfull "
                       "module. <br />";
constant module_unique = 1;
constant thread_safe = 1;		// I think this module should be :)

string defaultprefsbox;

void create()
{
#ifdef CAMAS_DEBUG
  defvar("debug",0,"Debug",TYPE_FLAG,"Debug the call / errors into Caudium "
         "error log ?");
#endif
   defvar("prefsbox", ".imhoprefs", "User preferences folder", TYPE_STRING,
         "Mail folder to hold user preferences. Relative to the preferences directory path and login name. ");
  defvar("autocreate", 1, "Auto create the folder", TYPE_FLAG,
         "If set to yes, the preference folder used to store preferences will be automatically created.<br />");
  defvar("logoutsave", 0, "Always save preferences on logout",
         TYPE_FLAG, "If set the preferences will always be saved for this module "
    	 "when the user logout. This is useful for migrating the preferences "
    	 "from other method to this one");
  defvar("prefsdir", "", "Preferences directory", TYPE_STRING,
        "Base directory to hold user preferences, if it is empty this module will not work. "
        "The preferences of a user whose login is john and if 'User preferences folder' is .imhoprefs, "
        "the preferences file for john will be saved to this path appended by john.imhoprefs");
}

void start(int cnt, object conf)
{
}

string status()
{
}

string query_provides()
{
  return("camas_preferences");
}

void stop()
{
}

/*
 * What we provide here
 */

//
//! method: int version(void)
//!  Give the CAMAS_PREFERENCES api version
//!  supported by the module
//! returns:
//!  the version of the API
//
int version()
{
  return 1;
}

//
//! method: mixed set_preferences(object id)
//!  Save the preferences into this module method
//! returns:
//!  a void by default
//!  an array containing the IMAP commands if using the 
//!  the IMAP module
//
mixed set_preferences(object id)
{
  if(CSESSION->usersetup && QUERY(prefsdir) && sizeof(QUERY(prefsdir)))
  {
    mapping prefs = ([ ]);
    foreach (indices(CAMAS_MODULE->prefproperties), string prop) 
    {
      if (CSESSION[prop] && CSESSION["usersetup"+prop])
        prefs += ([ prop: (string) CSESSION[prop] ]);
    }
    object prefsfile = Stdio.File();
    string basepath = QUERY(prefsdir);
    string prefspath = combine_path(basepath, lower_case(CSESSION->login) + QUERY(prefsbox));

    if(QUERY(autocreate) && !Stdio.exist(basepath))
      Stdio.mkdirhier(basepath);
    if(prefsfile->open(prefspath, "wct")) 
    {
      prefsfile->write(CAMAS.Tools.serialize_prefs(prefs) ||"");
      prefsfile->close();
    }
    else
      report_warning("CAMAS: Could not write prefsfile: " + prefspath + "\n");
  }
}

//
//! method: mixed get_preferences(object id)
//!  Get the preferences from this module method
//! returns:
//!  a void by default
//!  an array containing the IMAP commands if using the 
//!  the IMAP module
//
mixed get_preferences(object id)
{
  if(QUERY(prefsdir) && sizeof(QUERY(prefsdir)))
  {
    object prefsfile = Stdio.File();
    string basepath = QUERY(prefsdir);
    string prefspath = combine_path(basepath, lower_case(CSESSION->login) + QUERY(prefsbox));    
    string prefs_string = Stdio.read_bytes(prefspath);
    if(!prefs_string)
    {
      report_warning("CAMAS: Could not open prefsfile: " + prefspath + "\n");
    }
    else
    {
      mapping(string:string) prefs = CAMAS.Tools.deserialize_prefs(prefs_string);
      foreach(indices(prefs), string pref_name)
      {
        if(CAMAS_MODULE->prefproperties[pref_name] 
            && CSESSION[pref_name] && CSESSION["usersetup"+pref_name])
          CSESSION[pref_name] = prefs[pref_name];
      }
      if (!CSESSION->layout || (CSESSION->layout == "0"))
        CSESSION->layout = CAMAS_MODULE->QUERY (defaultlayout);
      if (CSESSION->overridelayout)
        CSESSION->layout = CSESSION->overridelayout;
      CSESSION->prefsloaded = 1;
    }
  }
}

//
//! method: mixed save_on_logout(id)
//!  Do we have to save the preferences on each user logout ?
//! returns:
//!  a void by default
//!  an array containing the IMAP commands if using the 
//!  the IMAP module
//
mixed save_on_logout(object id)
{
  if(QUERY(logoutsave))
    set_preferences(id);
}

/*
 * If you visit a file that doesn't contain these lines at its end, please     
 * cut and paste everything from here to that file.                            
 */                                                                            

/*
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

/* START AUTOGENERATED DEFVAR DOCS */

//! defvar: debug
//! Debug the call / errors into Caudium error log ?
//!  type: TYPE_FLAG
//!  name: Debug
//
//! defvar: defaultprefsbox
//! Mail folder to hold user preferences. Relative to the default mail folder path. This option can be overridden by a different setting in the IMAP server list.<br /><b>Note</b>: You should not have any '.' if using '.' as a namespace (usually the case if you put 'INBOX.' in IMAP mail folder path).
//!  type: TYPE_STRING
//!  name: User preferences folder
//
//! defvar: autocreate
//! If set to yes, the IMAP folder used to store preferences will be automatically created.<br />Warning: this option will only work if you enable Mailboxes in Camas Features -&gt; Features.
//!  type: TYPE_FLAG
//!  name: Auto create the folder
//
//! defvar: logoutsave
//! If set the preferences will always be saved for this module when the user logout. This is useful for migrating the preferences from other method to this one
//!  type: TYPE_FLAG
//!  name: Always save preferences on logout
//

/*
 * If you visit a file that doesn't contain these lines at its end, please
 * cut and paste everything from here to that file.
 */

/*
 * Local Variables:
 * c-basic-offset: 2
 * End:
 *
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

