/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * Based on IMHO  Stefan Wallstrm and Bosse Lincoln.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: ebook.pmod,v 1.12 2004/01/13 11:01:38 vida Exp $
 */

#include <camas/globals.h>

class ebook {

  private mapping(string:mapping) m_entries;
  private array(string) m_fields;

  void create() {
    m_entries = ([]);
    m_fields = ({});
  }

  void set_fields(array(string) fieldnames) {
    int i;
    m_fields = allocate(sizeof(fieldnames));
    for (i=0; i < sizeof(fieldnames) ; i++ ) {
      m_fields[i] = replace(fieldnames[i], " ", "");
    }
  }

  array(string) get_fields() {
    array (string) r = allocate(sizeof(m_fields));
    for (int i=0; i < sizeof(m_fields) ; i++ ) r[i] = m_fields[i];
    return r;
  }

  void set_entry(string key, string field, string value) {
    if (!m_entries[key]) m_entries += ([ key: ([]) ]);
      m_entries[key][field] = value||"";
  }

  string get_entry(string key, string field) {
    if (!m_entries[key]) return "";
    if (!m_entries[key][field]) return "";
    return m_entries[key][field];
  }

  void del_entry(string key) {
    if (m_entries[key]) m_delete (m_entries, key);
  }

  void import_mime(object mimemess) {
    int i;
    string k, v, line;
    array(string) fields, values;
    if (!mimemess->headers[HEADER_EBOOK_FIELDS]) return;
    fields = mimemess->headers[HEADER_EBOOK_FIELDS] / ",";
    foreach(mimemess->getdata() / "\n", line) {
      if (sscanf(line, "%s = %s", k, v) == 2) {
        values = v / ",";
        if (sizeof(values) != sizeof(fields)) continue;
        for(i=0 ; i < sizeof(fields) ; i++) set_entry(k,fields[i], values[i]);
      }
    }
    set_fields(fields);
  }

  object(MIME.Message) export_mime() {
    int i;
    string f, k;
    string data = "";
    object r = MIME.Message("", ([
                               "MIME-Version" : "1.0",
                               "subject" : HEADER_EBOOK_SUBJECT_VALUE,
                               HEADER_EBOOK_FIELDS: (m_fields * ",")
                                 ]) );
    r->type = "text";
    r->subtype = "plain";
    r->setcharset("UTF-8");
    foreach(indices(m_entries), k) {
      data += k + " = " + get_entry(k, m_fields[0]);
      for (i=1 ; i < sizeof(m_fields) ; i++) {
        data += "," + get_entry(k, m_fields[i]);
      }
      data += "\n";
    }
    r->setdata(data);
    return r;
  }
}
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

