/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: module.pmod,v 1.10 2004/01/13 11:01:38 vida Exp $
 */
//! file: module.pmod
//!  Handler of Camas Formbutton common functions
//! cvs_version: $Id: module.pmod,v 1.10 2004/01/13 11:01:38 vida Exp $

// === FORM BUTTONS ===
//! method: string form_buttons(string action, string value, void|string onClick)
//!  Return HTML code to handling standart form buttons.
//! returns:
//!  Formatted &lt;input type="submit" ... &gt; code with the value given in arguments.
//! arg: string action
//!  The "name" of the action for this submit button
//! arg: string value
//!  The "value" of the action for this submit button
//! arg: mappings
//!  Optional arguments for this button
string form_buttons(string action, string value, mapping args)
{
  args -> type = "submit";
  args -> name = action;
  args -> value = value;
  args -> alt  = value;
  
  return CAMAS.Tools.make_tag("input", args);
}
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

