/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: CompatTools.pmod,v 1.7 2004/01/13 11:01:37 vida Exp $
 */

//! file: CompatTools.pmod
//!  Caudium Compatibilty Tools for CAMAS when running on Caudium 1.0
//! cvs_version: $Id: CompatTools.pmod,v 1.7 2004/01/13 11:01:37 vida Exp $


// Function that are on caudiumlib.pike only on Caudium 1.1

//! method: int parse_scopes(string data, function cb, object id, mixed ... extra)
//!  Parse the data for entities.
//! arg: string data
//!  The text to parse.
//! arg: function cb
//!  The function called when an entity is encountered. Arguments are:
//!  the parser object, the entity scope, the entity name, the request id
//!  and any extra arguments specified.
//! arg: object id
//!  The request id object.
//! arg: mixed ... extra
//!  Optional arguments to pass to the callback function.
//! returns:
//!  The parsed result.
//! name: parse_scopes - parse text for entities

#if constant(Parser.HTML)
static mixed cb_wrapper(object parser, string entity, object id, function cb,
                        mixed ... args) {
  string scope, name, encoding;
  array tmp = (parser->tag_name()) / ":";
  entity = tmp[0];
  encoding = tmp[1..] * ":";
  if(!encoding || !strlen(encoding))
    encoding = (id && id->misc->_default_encoding) || "html";
  if(sscanf(entity, "%s.%s", scope, name) != 2)
    return 0;
  mixed ret = cb(parser, scope, name, id, @args);
  if(!ret) return 0;
  if(stringp(ret)) return roxen_encode(ret, encoding);
  if(arrayp(ret)) return Array.map(ret, roxen_encode, encoding);
}

string parse_scopes(string data, function cb, object id, mixed ... extra) {
  object mp = Parser.HTML();
  mp->lazy_entity_end(1);
  mp->ignore_tags(1);
  mp->set_extra(id, cb, @extra);

  mp->_set_entity_callback(cb_wrapper);
  return mp->finish(data)->read();
}
#else
string parse_scopes(string data, function cb, object id, mixed ... extra) {
  error("Parser.HTML is required.\n");
}
#endif

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

