/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2001 The Caudium Group
 * Copyright  1994-2001 Roxen Internet Software
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: camas_layout_default.pike,v 1.3.4.1 2001/09/24 11:10:57 kiwi Exp $
 */

#include <module.h>
inherit "module";

#include <camas/defaultlayout.h>

inherit "caudiumlib";

//
//! module: CAMAS: Default Layout
//!  This module handle default layout (e.g. skin) for CAMAS.<br />
//!  <b>This module is automatically selected if you select "CAMAS: Main 
//!  module".</b>
//! inherits: module
//! inherits: caudiumlib
//! type: MODULE_PROVIDER
//! cvs_version: $Id: camas_layout_default.pike,v 1.3.4.1 2001/09/24 11:10:57 kiwi Exp $
//

constant cvs_version = "$Id: camas_layout_default.pike,v 1.3.4.1 2001/09/24 11:10:57 kiwi Exp $";
constant module_type = MODULE_PROVIDER;
constant module_name = "CAMAS: Default Layout";
constant module_doc  = "This module handle default layout (e.g. skin) for "
                       "CAMAS.<br /><b>This module is automatically selected if "
                       "you select \"CAMAS: Main module\".</b>";
constant module_unique = 1;
constant thread_safe = 1;		// I think this module should be :)

void create () {

}

void start (int num, object conf) {
  module_dependencies (conf, ({ "camas_layout_manager" }));

  conf->get_provider ("camas_layout_manager")->add_layout (this_object ());
}

void stop () {
  my_configuration ()->get_provider ("camas_layout_manager")->remove_layout (this_object ());
}

string status () {
  return "CAMAS Default Layout Module.<br />";
}

string query_provides ()
{
  return ("camas_layout");
}

string name () {
  return "Default";
}

string get_layout (string layout, void|int screen) {
  return DEFAULTLAYOUT;
}
