/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2001 The Caudium Group
 * Based on IMHO  Stefan Wallstrm and Bosse Lincoln.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: smtp.h,v 1.3.6.1 2001/09/19 11:38:47 kiwi Exp $
 */
/*
 * CAMAS SMTP client
 */

void|string smtp_send (object imho, mapping sessobj)
{
  object ESMTP_client;
  mixed err = catch {
#if constant (Protocols.ESMTP)
    ESMTP_client = Protocols.ESMTP.client (sessobj->smtpserver, sessobj->smtpport, imho->query ("smtpmaildomain"));
#else
    ESMTP_client = CAMAS.ESMTP.client (sessobj->smtpserver, sessobj->smtpport, imho->query ("smtpmaildomain"));
#endif
  };
  if (err)
    return "Failed to connect to SMTP server.";
  else
    {
      int dsn = 0;
#if constant(Protocols.ESMTP)
      if (sessobj->dsnsuccess) dsn |= Protocols.ESMTP.client.DSN_SUCCESS;
      if (sessobj->dsndelay) dsn |= Protocols.ESMTP.client.DSN_DELAY;
      if (dsn) dsn |= Protocols.ESMTP.client.DSN_FAILURE;
#else
      if (sessobj->dsnsuccess) dsn |= CAMAS.ESMTP.client.DSN_SUCCESS;
      if (sessobj->dsndelay) dsn |= CAMAS.ESMTP.client.DSN_DELAY;
      if (dsn) dsn |= CAMAS.ESMTP.client.DSN_FAILURE;
#endif
      err = catch {
	ESMTP_client->send_message (sessobj->address, sessobj->sendrecipients, sessobj->sendmail, dsn);
      };
      if (err)
	return "Failed to send mail.";
      else {
	ESMTP_client->close ();
	destruct (ESMTP_client);
      }
    }
}
