/* 
 * Network address calculation, copied from netconfig.c 
 */

#include <stdio.h>
#include <stdlib.h>
 
#define IP4_ADDR_SZ (4)
 
typedef struct ip4_addr
{
  int i[IP4_ADDR_SZ];
} ip4_addr_t;
 
char buffer[255];
 
int
main(int argc, char ** argv)
{
  int ix;
  ip4_addr_t ipaddr;
  ip4_addr_t netmask;
  ip4_addr_t network;
  ip4_addr_t broadcast;
  ip4_addr_t gateway;

  if(argc != 3) return -1;
  
  if(sscanf(argv[1], "%d.%d.%d.%d", &ipaddr.i[0], &ipaddr.i[1], &ipaddr.i[2], &ipaddr.i[3]) != 4) return -1;
  if(sscanf(argv[2], "%d.%d.%d.%d", &netmask.i[0], &netmask.i[1], &netmask.i[2], &netmask.i[3]) != 4) return -1;
 
  for (ix = 0; ix < IP4_ADDR_SZ; ix++) {
    gateway.i[ix] = network.i[ix] = ipaddr.i[ix] & netmask.i[ix];
    broadcast.i[ix] = (~netmask.i[ix] & 255) | ipaddr.i[ix];
  }
  gateway.i[IP4_ADDR_SZ - 1] |=
    (ipaddr.i[IP4_ADDR_SZ - 1] == (network.i[IP4_ADDR_SZ - 1] | 1)) ? 2 : 1;
 
  printf("export GATEWAY=%d.%d.%d.%d\n", gateway.i[0], gateway.i[1], gateway.i[2], gateway.i[3]);
  printf("export NETWORK=%d.%d.%d.%d\n", network.i[0], network.i[1], network.i[2], network.i[3]);
  printf("export BROADCAST=%d.%d.%d.%d\n", broadcast.i[0], broadcast.i[1], broadcast.i[2], broadcast.i[3]);
 
  return 0;
}
