#include <signal.h>
#include <stdio.h>
#include <sys/types.h>
#include <fcntl.h>
#include "dbootstrap.h"
#include "lang.h"
#include <syslog.h> 
#include "util.h"
#include <sys/mount.h>
#ifdef _TESTING_
  #include <stdio.h>
#endif

int reboot_system (void) {
  int write_common_network (void);
  sync();
  execlog("umount /instmnt", LOG_INFO);
  if (! bootargs.isquiet ) {
    if (strcmp(InstallationRootDevice, "/dev/fd0")) {
#ifdef __hppa__
      if (! bootargs.isquiet && ! yesNoBox(_("You are ready to reboot the system.  Note that you may need to tell your firmware to boot from the disk you installed the boot loader, PALO, on (unless that already happens to be the default boot device).\n\nReboot the system?"), _("Reboot the system?")) )
#else
      if (! bootargs.isquiet && ! yesNoBox(_("If you are ready to reboot the system, you'll need to make sure you are booting from the right media.\n\nIf you are booting from the local disk, make sure there are no floppies in the floppy drives and no CD-ROM in the tray.  If you made a custom boot floppy and want to boot from that, you should put that floppy in the first floppy drive.  Finally, you can restart the installation system by booting from your install media.\n\nPlease take care of all that before you answer \"Yes\" to the following question.\n\nReboot the system?"), _("Reboot the system?")) )
#endif
	return 1;
    } else {
      if (! bootargs.isquiet && ! yesNoBox(_("Since you've booted from the first floppy drive without using the RAM disk, please keep the Installation Root Disk in the drive until the system reboots. Then remove it, and press the <RESET> button on your system.\n\nReboot the system?"), _("Reboot the system?")) )
	return 1;
    }
//#if (#cpu(i386))
#if (0) /* the main advise is enough, do not bother users again */
{
  FILE *fd, *cd_info;
  char *p_line,*line = NULL;
  size_t line_size = 0;
  char bootmagic='\0';
  if (have_cdrom() && (cd_info = fopen ("/proc/sys/dev/cdrom/info", "r")) != NULL)
  {
    /* successfull, continuing */

    /* Read the file and build a list of available CD devices. */
    getline (&line, &line_size, cd_info);
    getline (&line, &line_size, cd_info);
    getline (&line, &line_size, cd_info);
    p_line = line + strlen(line) - 1; /* Point at \n at end of string. */
    *p_line-- = '\0';		/* chop \n */
    while (*p_line != ':')
    {
      while (!isspace(*(p_line - 1)))
        --p_line; /* scan backwards until char-before isspace() */

      {
        /* new local scope; not a while loop */ /* LOL */
        char dev[5 + strlen (p_line) + 1];
        strcpy (dev, "/dev/");
        strcpy (dev + 5, p_line);
        fd = fopen(dev, "r");
        if (!fd)
        {
          while (isspace(*(--p_line)))
            ; /* Scan backwards for end of previous non whitespace. */
          continue;
        }
        fseek (fd, 34887, SEEK_SET);
        fread (&bootmagic, 1, 1, fd);
	fclose(fd);
        if(bootmagic != '\0')
        {
          sprintf(prtbuf, _("Please note that the drive %s contains a bootable CD-ROM. If you enabled the cdboot option in your BIOS, you should remove the disk; otherwise, you will start the installation again and again."), dev);
          problemBox(prtbuf,  _("Please remove the CD"));

        }
      }
      while (isspace(*(--p_line))) /* Scan backwards for end of previous non whitespace. */
        ;
      *(p_line + 1) = '\0';
    }
    /* end of "while not looking-at ':'" */
    fclose (cd_info);
  }
}
#endif
  }

  if(!is_network_configured())
    write_common_network();
  execlog("cp /var/log/messages /target/var/log/installer.log", LOG_INFO);

  sync();
  boxSuspend();
#ifdef _TESTING_
  printf("Fake rebooting... (waiting 15 secs)\n");
#else
  system("reboot");
#endif
  sleep(15);
  boxResume();
  return 1;
}

/* This is the mondo cool "no-restart-just-continue-the-setup-in-the-new-system"
 * patch.
 */
int chroot_start (void) {
    int fd;
    struct fdisk_partition *mp;
    
#ifndef _TESTING_
    if (! initchroot_cap())
	goto bailout;
#endif

    if (! bootargs.isquiet && ! yesNoBox(_("The system configuration will continue after the system starts in the newly installed setup.\n\nNote, this bypasses a normal reboot, which means boot loader problems may not be apparent until you actually do reboot the system.\n\nStart the new system?"), _("Start the new system?")))
	return 1;
		
#ifndef _TESTING_
    /* Ok, first we must let init know where the new root will be */
    mp = fdisk_find_partition_by_mntpoint("/target");
    if ((fd = open("/proc/sys/kernel/init-chroot", O_WRONLY|O_TRUNC)) == -1)
	goto bailout;
    if (write(fd, "/target", 7) < 1)
	goto bailout;
    close(fd);

    /* Now we commit, and umount all but the new and current root */
    sync();
    boxSuspend();

    execlog("swapoff -a", LOG_INFO);
    
    for (mp = mounted_partitions; mp != NULL; mp = mp->next) {
	if (strcmp(mp->mount_point, "/") && strcmp(mp->mount_point, "/target"))
	    umount(mp->mount_point);
	else {
	    snprintf(prtbuf, sizeof(prtbuf), "mount -o remount,ro %s %s", mp->name,
		    mp->mount_point);
	    execlog(prtbuf, LOG_INFO);
	}
    }

    /* make sure we mount "/" read-only */
    execlog("mount -o remount,ro /dev/root /", LOG_INFO);

    /* Don't signal PID 1, let 'reboot' do it */
    fprintf(stderr, _("Rebooting...\n"));
    execlog("reboot", LOG_INFO);
    sleep(15);
    
bailout:
    boxResume();
#endif /* !_TESTING_ */
    wideMessageBox(_("\nCould not setup init-chroot for starting the new system. Try simply rebooting instead (this is not a bug).\n"),
	    _("System start failed"));
    return 1;
}

#ifdef _TESTING_
/* To test, compile using: make reboot_system_test */
void main(void){
	LOAD_TRMFILE("test.trm");
	get_kver();
	boxInit();

	InstallationRootDevice=strdup("/dev/sdc");
	reboot_system();

	boxFinished();
}
#endif

