#include <unistd.h>
#include "lang.h"
#include "util.h"
#include "dbootstrap.h"

char *files[] = {
  "/var/log/messages",
  "/proc/cpuinfo",
  "/proc/pci",
  "/proc/cmdline",
  "/proc/partitions",
  "/proc/mounts",
  "/proc/version",
  "/etc/fstab",
  NULL,
};

static int
mount_floppy (char *device)
{
  int status = 1;
  const char **fs_type;
  for (fs_type = fs_type_tab; *fs_type; fs_type++)
    {
      status =
	vexeclog (LOG_DEBUG, "mount -t %s %s /floppy", *fs_type, device);
      if (status == 0)		/* success */
	break;
    }

  return status;
}

int
generate_problem_report ()
{
  int i = 0;
  char *dest;
  char *floppy_device = NULL;
  static struct fdisk_disk *disk;
 
  disqtype = problem_report;

  if (choose_medium ())
    return 1;

  if (!strncmp (Archive_Dir, "/dev/fd", 7)
#ifdef SCSI_FLOPPY
      || !strncmp (Archive_Dir, "/dev/sfd", 8)
#endif
    )
    {
      floppy_device = Archive_Dir;

      vexeclog (LOG_DEBUG, "umount %s", floppy_device);
      execlog ("umount /floppy", LOG_DEBUG);

      vaproblemBox (_("Report Generator"),
		    _("I will write a report to %s.  Please insert a floppy."),
		    floppy_device);

      if (mount_floppy (floppy_device))
	{
	  if (yesNoBox
	      (_("I could not mount the floppy.  Would you like to make an ext2 filesystem on the floppy (thus erasing all it's data)?"),
	       _("Mount failed")) == 0)
	    goto failure;
	  if (vexeclog
	      (LOG_DEBUG, "mke2fs %s >/dev/null 2>&1", floppy_device))
	    goto failure;
	  if (mount_floppy (floppy_device))
	    goto failure;
	}
      dest = "/floppy";

    }
  else
    {
      dest = Archive_Dir;
    }

  if (execlog
      ("rm -rf /tmp/dbg_log/ && mkdir /tmp/dbg_log/ ",
       LOG_DEBUG))
    goto failure;

  if (vexeclog (LOG_DEBUG, "rm -f %s/dbg_log.*", dest))
      goto failure;

  while (files[i])
    {
      if (vexeclog (LOG_DEBUG, "cp %s /tmp/dbg_log", files[i]))
	goto failure;
      i++;
    }

  disk = fdisk_disks;
  while (disk) {
    char *dev;
    dev = strrchr(disk->name, '/') + 1;
    snprintf (prtbuf, sizeof(prtbuf), "fdisk -l %s > /tmp/dbg_log/%s.fdisk-dump 2>&1",
			     disk->name, dev);
    system(prtbuf);
    disk = disk->next;
  }

  if (vexeclog (LOG_DEBUG,
	  "cd /tmp ; tar -c dbg_log/ | gzip > %s/dbg_log.tgz", dest))
    goto failure;

  if (floppy_device)
      execlog ("umount /floppy", LOG_DEBUG);
  else 
      unmount_dir("/instmnt");
  free (Archive_Dir);
  Archive_Dir = NULL;
  problemBox (_("Problem report saved as dbg_log.tgz"), 
	      _("Success"));
  return 0;

failure:
  if (floppy_device)
      execlog ("umount /floppy", LOG_DEBUG);
  else 
      unmount_dir("/instmnt");
  free (Archive_Dir);
  Archive_Dir = NULL;
  problemBox (_("An error occured while generating the problem report, sorry."),
	      _("Problem"));
  return -1;
}


#ifdef _TESTING_
int
main ()
{
  LOAD_TRMFILE ("test.trm");
  InstallationRootDevice = block_device ("/");
  fdisk_reread();
  get_kver ();
  boxInit ();
  return generate_problem_report ();
}
#endif
