#include <malloc.h>
#include <string.h>
#include "notail.h"

struct notail *NT_HEAD=NULL;

struct notail *newrecord (void);

/* returns true(1) if the argument matches mnt in the linked list */
int need_notail (char *mnt)
{
  struct notail *record;

  record = NT_HEAD;

  while (record != NULL)
  {
    if (!strcmp (mnt, record->mnt))
       return 1;
    record = record->next;
  }
  return 0;
}
  
/* yeah, the use of strdup will cause memory leaks. give me a place to 
   clean it up. */
int addnotail (char *mnt)
{
  struct notail *record;

  if (mnt == NULL)
    return -1;
  
  if (NT_HEAD == NULL)
  {
    record = newrecord();
    if (record == NULL)
      return -1;
    NT_HEAD=record;
  }
  else
  {
    for (record=NT_HEAD; record->next != NULL; record=record->next)
      ;

    record->next = newrecord();
    if (record->next == NULL)
      return -1;

    record = record->next;
  }

  record->mnt = strdup(mnt);
  if (record->mnt == NULL)
    return -1;

  return 0;
}

struct notail *newrecord (void)
{
  struct notail *record;
   
  record = (struct notail *)malloc (sizeof (struct notail));
  if (record == NULL)
    return NULL;

  record->mnt = NULL;
  record->next = NULL;

  return record;
}
