#! /bin/bash
# This program builds the nfs-root archive from root.bin.
# (C) Eric Delaunay, 1998
# This is free software under the GNU General Public License.


. ./common.sh

umask 022
export LANG=C

if [ $# != 4 -a $# != 5 ]; then
	cat 1>&2 << EOF
	Usage: "$0" root.bin debian-version system language

	root.bin: the root.bin disk image.
	debian-version: version of the Debian release.
	system: name of the target system.
	language: language for the release notes
	filename: name of the final file (optional)
EOF
	exit -1
fi

# Set this to the location of the root.bin disk image.
rootimage=$1

#Set this to the Debian version
debianversion=$2

# Set this to the system
system=$3

# Set this to the language for the release notes.
language=$4

# This is the name of the file to output, we use "root.tar.gz"
# if this is not specified
rootfile=$5
[ "x$rootfile" != x ] || rootfile=root.tar.gz

# Set this to the block device for the root image
mnt=${tmpdir}/boot-floppies/mnt.rootdisk

make_tmpdir $mnt

# Set this to the temporary directory needed to create the archive file
rootarchive=${tmpdir}/boot-floppies/rootarchive.$$

rootsystem=$rootarchive/debian-$arch-root

rm -fr $rootarchive
make_tmpdir $rootarchive

( $ROOTCMD umount $mnt ; true )2>/dev/null >/dev/null

# first, uncompress root.bin if needed
if file $rootimage | grep gzip > /dev/null; then
	info "uncompressing $rootimage for $rootarchive/root.bin"
	zcat $rootimage > $rootarchive/root.bin
else
	cp $rootimage $rootarchive/root.bin
fi
$ROOTCMD mount -t ext2 -o loop $rootarchive/root.bin $mnt

info "extracting from root.bin into $rootarchive"
make_tmpdir $rootarchive/mnt.rootdisk
tar -C $mnt -cf - . | tar -C $rootarchive/mnt.rootdisk -xf -
mv $rootarchive/mnt.rootdisk $rootsystem

$ROOTCMD umount $mnt

info "messing with $rootsystem/dev"
# add the NFSROOT device for net booting
mknod $rootsystem/dev/root b 0 1

# SECURITY ALERT: when this archive is installed on a server, all devices are
# publicly avalaible to users who can login to it, like all of them under
# /dev.  They are under /tftpboot/debian-$sparc-root/dev or like.  However,
# their permissions are somewhat different.  For example, /dev/tty[pq...]* are
# writable for all :-(
# To avoid potential security hole, all devices are made accessible only by
# root: not a problem for bootstrapping installation, since it runs as root.
chmod -R og-rw $rootsystem/dev

info "creating $rootfile"
# archive the debian-$arch-root directory
tar -C $rootarchive -cf - `basename $rootsystem` | gzip -9c > $rootfile

# clean up
rm -fr $rootarchive

info NFS rootable tar archive is `ls -l $rootfile`
ls -l $rootfile

exit 0
