#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <dirent.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "dbootstrap.h"
#include "lang.h"
#include <syslog.h> 
#include "util.h"

/*
 * Button length for tz_dialogBox
 */
#undef _ButtonH
#define _ButtonH (1)

#define SEDCOMMAND "sed"

/*
 * Function prototypes
 */
int configure_timezone(void);
static int write_timezone(char *localtime, char *timezone);
static int read_directory(const char* dirname,
		    struct list *files,
		    struct list *dirs);
static int configure_timezone_step1();
#ifdef LOCALTIME
static int configure_timezone_step2();
#endif
static int compare(const void*,const void*);

/*
 * write_timezone
 * Deletes the previous local_time, creates a symlink to the
 * new one and writes the timezone.
 */
static int write_timezone(char *localtime, char *timezone) {
  #ifndef _TESTING_
  char dest_tz[]="/target/etc/timezone";
  char dest_lt[]="/target/etc/localtime";
  #else
  char dest_tz[]="./etc_timezone_test";
  char dest_lt[]="./etc_localtime_test";
  #endif
  FILE* pfile;

  unlink(dest_lt);
  symlink(localtime,dest_lt);
  pfile=fopen(dest_tz,"w");
  fprintf(pfile,"%s\n",timezone);
  fclose(pfile);
  return 0;
}
	  

/*
 * configure_timezone_step1
 * Performs the timezone selection and setting.
 */
static int configure_timezone_step1() {
  #ifndef _TESTING_
  char target[]="/target";
  char dir_sfx[]="/usr/share/zoneinfo";
  #else
  char target[]="";
  char dir_sfx[]="/usr/share/zoneinfo";
  #endif
  int  dir_length=strlen(target)+strlen(dir_sfx)+3;
  char *dir=calloc(dir_length,sizeof(char));
  char *rel_dir=calloc(1,sizeof(char));
  char *timezone=(char *)NULL;
  char *localtime=(char *)NULL;

  char buf[4096];
  struct list files={ 0,(char **)NULL };
  struct list dirs={ 0,(char **)NULL };
  int result;
  int idx;
  int sz;
  char *substr;
  rel_dir[0]='\0';

  /*
   * Initialise the directory information.
   */
  strcpy(dir,target);
  strcat(dir,dir_sfx);
  dir[dir_length-2]='/';
  dir[dir_length-1]='.';
  dir[dir_length]='\0';

  for(;;) {
    if (read_directory(dir, &files, &dirs) != 0) {
      if (strlen(dir) < 4098 - strlen(_("Error: Unable to open %s.\n")))
	sprintf(buf, _("Error: Unable to open %s.\n"), dir);
      else
	sprintf(buf, _("Error: Unable to open the directory.\n"));
      problemBox(buf, _("Timezone Config Error"));
    }
    if ( (result = tz_dialogBox(_("Please select the appropriate location in the world in which you live.  We suggest you use the left pane to specify your time zone by country or continent."),
				_("Timezone Configuration"), 18, 66, &dirs, &files))
	 == DLG_CANCEL)
      return -1;
    else if (result<OPT_D) {
      timezone = calloc(strlen(rel_dir)+
			strlen(files.data[result-OPT_F]) + 2, sizeof(char));
      if (strlen(rel_dir) > 0) {
	strcpy(timezone, rel_dir);
	strcat(timezone + strlen(rel_dir), "/");
	strcat(timezone + strlen(rel_dir) + 1, files.data[result - OPT_F]);
      }
      else
	strcpy(timezone,files.data[result-OPT_F]);
	  
      localtime = calloc(strlen(dir_sfx) +
			 strlen(rel_dir) +
			 strlen(files.data[result-OPT_F]) +
			 3, sizeof(char));
      strcpy(localtime, dir_sfx);
      strcat(localtime + strlen(dir_sfx), "/");
      strcat(localtime + strlen(dir_sfx) + 1, rel_dir);
      strcat(localtime + strlen(dir_sfx) + strlen(rel_dir) + 1, "/");
      strcat(localtime + strlen(dir_sfx) + strlen(rel_dir) + 2,
	     files.data[result - OPT_F]);
	  
      write_timezone(localtime, timezone);

      free(localtime);
      free(timezone);
	  
      for (idx = 0; idx < files.nelem; idx++)
	free(files.data[idx]);
      free(files.data);
      for (idx = 0; idx < dirs.nelem; idx++)
	free(dirs.data[idx]);
      free(dirs.data);
	  
      return DLG_OKAY;
    }
    else {
      if (result - OPT_D == 0) { /* It's the ".." directory. */
	if (strlen(rel_dir) != 0) { /* We are NOT in the top_level */
	  /*
	   * Re-adjust rel_dir and dir.
	   */
	  if ((substr = strrchr(rel_dir, '/')) == NULL)
	    sz = 0;
	  else
	    sz = strlen(rel_dir) - strlen(substr);
	  rel_dir = realloc(rel_dir, sz + 1);
	  rel_dir[sz] = '\0';

	  /*
	   * Remeber: dir always ends with a '/'
	   */ 
	  sz = strlen(dir);
	  dir[sz - 1] = '\0';
	  substr = strrchr(dir, '/');
	  sz -= strlen(substr);
	  dir = realloc(dir, sz);
	  dir[sz - 1] = '\0';
	}
      } else {
	rel_dir = realloc(rel_dir,
			  strlen(dirs.data[result - OPT_D]) +
			  strlen(rel_dir) + 2);
	if (strlen(rel_dir) > 0) {
	  strcat(rel_dir + strlen(rel_dir), "/");
	  strcat(rel_dir + strlen(rel_dir), dirs.data[result - OPT_D]);
	} else
	  strcpy(rel_dir, dirs.data[result - OPT_D]);
	      
	dir = realloc(dir, strlen(dir) + strlen(dirs.data[result - OPT_D]) + 2);
	strcat(dir + strlen(dir), "/");
	strcat(dir + strlen(dir), dirs.data[result - OPT_D]);
      }
	  
	  
      /*
       * Free memory to restart the directory search.
       */
      for (idx = 0; idx < files.nelem; idx++)
	free(files.data[idx]);
      free(files.data);
      files.nelem = 0;
      for (idx = 0; idx < dirs.nelem; idx++)
	free(dirs.data[idx]);
      free(dirs.data);
      dirs.nelem = 0;
    }
  }
}

/*
 * read_directory
 * This will check the current directory for other directories or
 * new files and will generate and allocate the memory for both lists.
 * char *dir    - Name of the directory to process
 * struct list* - List of the files in that directory.
 * struct dirs* - List of the sub-directories in that directory.
 */
static int read_directory(const char* dir,
		   struct list* files, struct list* dirs)
{
  DIR* pdir;
  struct dirent *current;
  struct stat buffer;

  int ndir = 0;
  int nfile = 0;
 
  char* tmp_name;
  int   tmp_sz;
  char* path;

  char error[4096];
  /*
   * Open directory
   */
  if ((pdir = opendir(dir)) == NULL) {
    problemBox(_("The base system has not yet been installed."), _("Timezone Config Error"));
    return -1;
  }
  
  while ((current = readdir(pdir)) != NULL) {
    tmp_sz = strlen(current->d_name) + 1;
    path = calloc(strlen(dir) + tmp_sz + 1,
		  sizeof(char));
    strncpy(path, dir, strlen(dir));
    strncat(path + strlen(dir), "/", 1);
    strcat(path + strlen(dir) + 1, current->d_name);

    if (stat(path, &buffer) == -1) {
      sprintf(error, _("Could not stat file %s."), path);
      problemBox(error, _("Timezone Config Error"));
    }
    if (S_ISDIR(buffer.st_mode)) {
      if (strcmp(current->d_name, "."))
	ndir++;
    }
    else if (S_ISREG(buffer.st_mode))
      nfile++;
    free(path);
  }
  
  dirs->data = (char **)calloc(ndir, sizeof(char *));
  files->data = (char **)calloc(nfile, sizeof(char *));
  rewinddir(pdir);
  
  while ((current = readdir(pdir)) != NULL) {
    tmp_sz = strlen(current->d_name) + 1;
    tmp_name = calloc(tmp_sz, sizeof(char));
    strcpy(tmp_name, current->d_name);
      
    path = calloc(tmp_sz + strlen(dir) + 1, sizeof(char));
    strncpy(path, dir, strlen(dir));
    strncat(path + strlen(dir), "/", 1);
    strcat(path + strlen(dir) + 1, tmp_name);

    if (stat(path, &buffer) == -1) {
      sprintf(error, _("Could not stat file %s."), tmp_name);
      problemBox(error, _("Timezone Config Error"));
    } else {
      if (S_ISDIR(buffer.st_mode)) {
	if (strcmp(tmp_name, "."))
	  dirs->data[(dirs->nelem)++] = tmp_name;
      }
      else if (S_ISREG(buffer.st_mode))
	files->data[(files->nelem)++] = tmp_name;
    }
    free(path);
  }

  qsort((void*)files->data, files->nelem, sizeof(char*), compare);
  qsort((void*)dirs->data,dirs->nelem, sizeof(char*), compare);
  return 0;
}

#ifdef LOCALTIME
/*
 * configure_timezone_step2
 * Dialog to determine whether the clock is set to GMT or no.
 */
static int configure_timezone_step2() {

  char *yesno_intro=_("Unix system clocks are generally set to GMT (\"Greenwich Mean Time\", also known as Universal Coordinated Time, or UTC).  The operating system knows your time zone and convert system time into the local time.  You can choose whether the hardware clock should be set to either GMT (recommended for a Linux-only system) or local time (which may be more convenient for a system that also run other operating systems).\nThe hardware clock says the time is now\n");
  char *yesno_suffix=_("Will the hardware clock be set to GMT?");
  time_t now;
  char *buf;
  int result;
  
  if ( bootargs.isquiet )	/* quiet defaults to UTC */
    return 0;

  time(&now);
  buf = calloc(strlen(yesno_intro) + strlen(yesno_suffix) + 256, sizeof(char));
  sprintf(buf, "%s %s%s\n", yesno_intro, ctime(&now), yesno_suffix);
  result = yesNoBox(buf, _("Timezone Configuration"));
  free(buf);

  if (result == 0) {
      /*
       * Edit the /etc/default/rcS file as needed
       */
#ifndef _TESTING_
      execlog(SEDCOMMAND
	      " -e 's:^UTC=\"yes\":UTC=\"no\":' -e 's:^UTC=yes:UTC=no:'"
	      " /target/etc/default/rcS > /target/etc/default/rcS.new", LOG_INFO);
      execlog("mv /target/etc/default/rcS.new /target/etc/default/rcS", LOG_INFO);
      chmod("/target/etc/default/rcS", S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IROTH);
#endif
  } else {
      /*
       * revert if the /etc/default/rcS file is already modified
       */
#ifndef _TESTING_
      execlog(SEDCOMMAND
	      " -e 's:^UTC=\"no\":UTC=\"yes\":' -e 's:^UTC=no:UTC=yes:'"
	      " /target/etc/default/rcS > /target/etc/default/rcS.new", LOG_INFO);
      execlog("mv /target/etc/default/rcS.new /target/etc/default/rcS", LOG_INFO);
      chmod("/target/etc/default/rcS", S_IRUSR|S_IWUSR|S_IXUSR|S_IRGRP|S_IROTH);
#endif
  }
  
  return 0;
}
#endif

/*
 * Main timezone configuration routine.
 * The process is divided in two steps:
 * 1st we select the timezone for the system.
 * 2nd we determine whether the clock should use UTC.
 */
int configure_timezone(void)
{
  int result;
  result = configure_timezone_step1();
#ifdef LOCALTIME
  if (result == 0)
    result = configure_timezone_step2();
#endif
  return result;
}

int compare(const void *a, const void *b)
{
  const char** _a = (const char**)a;
  const char** _b = (const char**)b;
  
  if (**_a == '.')
    return(-1);
  else if (! (**_b) == '.')
    return(1);
  else
    return strcmp((*_a), (*_b));
}

#ifdef _TESTING_
/* To test, compile using: make tzconfig_test */
int main(void) {
  LOAD_TRMFILE("test.trm");
  get_kver();
  boxInit();
  configure_timezone();
  boxFinished();
  exit (0);
}
#endif
