#! /usr/bin/python

__copyright__ = '''
 Copyright (C) 1999,2000 The Software in the Public Interest (SPI)
 Written by Michael Sobolev <mss@transas.com>

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
'''

import sys, os, string

from xmlhelper import get_dom, filter_by_name, get_node_attr, get_node_attrs, get_attr, get_node_name, get_childnodes

from helpers import Language, List, Item

from dumper import dumper

def minimize_list (list):
    result = None   # default value

    if len (list.items) == 1:
        result = list.items[0]

        result.name = list.name + ' - ' + result.name
    elif len (list.items) > 1:
        result = list

    return result

def get_attr_default (attrs, name, default):
    result = get_attr (attrs, name)

    if result is None:
        result = default

    return result

def process_list (list, arch):
    result = None   # Just in case

    for child in list.childNodes:
        tagName = child.tagName

        if tagName == 'name':
            result = List (name = filter_by_name (list, 'name')[0].childNodes[0].data, items = [])
        elif tagName == 'list':
            tempo = minimize_list (process_list (child, arch))

            if tempo:
                result.items.append (tempo)
        elif tagName == 'item':
            attrs = child.attributes

            if arch in string.split (get_attr (attrs, 'arch')):
                result.items.append (Item (name = child.childNodes[0].childNodes[0].data, locale = get_attr (attrs, 'locale'), font = get_attr (attrs, 'font'), acm = get_attr_default (attrs, 'acm', ''), keymap = get_attr (attrs, 'keymap'), msgcat = get_attr (attrs, 'msgcat')))
        else:
            pass

    return result

def process_language (lang, arch):
    attrs = get_node_attrs (lang)

    name = filter_by_name (lang, 'name')[0].childNodes[0].data
    hint = filter_by_name (lang, 'hint')[0].childNodes[0].data

    ename = get_node_attr (lang, 'name')

    if ename is None:
        print lang, 'does not have attribute "name"'
        sys.exit (1)

    charset = get_attr (attrs, 'charset')
    font = get_attr (attrs, 'font')
    acm = get_attr_default (attrs, 'acm', '')

    result = Language (name = name, ename = ename, charset = charset, font = font, acm = acm, hint = hint, list =  process_list (lang.childNodes[2], arch))

    return result

def run (root, arch):
    if get_node_name (root) != 'languages':
        raise 'Do not know how to handle %s' % root.tagName

    result = []

    for child in get_childnodes (root):
        lang = process_language (child, arch)

        if lang.list and len (lang.list.items) > 0:
            result.append (lang)

    return result

argc = len (sys.argv)

if argc < 4:
    print 'usage: ver2.py utf? arch input [ output ]'
    sys.exit (1)

if argc == 4:
    utf, arch, input = sys.argv[1:]
    output = ''
else:
    utf, arch, input, output = sys.argv[1:]

print 'processing "%s", utf=%s, arch=%s' % (input, utf, arch)

domtree = get_dom (input)

result = run (domtree.documentElement, arch)

if len (result) > 0:
    if argc == 5:
        if sys.argv[3] == '-':
            outfile = sys.stdout
            print 'using stdout'
        else:
            outfile = open (output, 'w')

            print 'opening', output
    else:
        outfile = open (os.path.splitext (input)[0] + '.c', 'w')
        print 'opening', os.path.splitext (input)[0] + '.c'

    dumper (arch) (utf == '0', outfile, result)

    print 'dumper finished'

    outfile.close ()
else:
    sys.stderr.write ('No items for arch %s found.  No file generated\n' % arch)

    sys.exit (2)
