/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <string.h>

#include <glib.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#include "pixbuf-metadata.h"
#include "metadata-defines.h"

gboolean
bkl_task_pixbuf_get_metadata (GFile      *file,
                              GFileInfo  *info,
                              const char *mimetype,
                              GHashTable *metadata)
{
    char *path;
    int width, height;
    gboolean ret = FALSE;

    if (strncmp (mimetype, "image/", 6) != 0) {
        return FALSE;
    }

    path = g_file_get_path (file);
    if (gdk_pixbuf_get_file_info (path, &width, &height)) {
        g_hash_table_insert (metadata, METADATA_IMAGE_WIDTH,
                             g_strdup_printf ("%i", width));
        g_hash_table_insert (metadata, METADATA_IMAGE_HEIGHT,
                             g_strdup_printf ("%i", height));
        ret = TRUE;
    }

    g_free (path);
    return ret;
}
