/*
 * Bickley - a meta data management framework.
 * Copyright © 2008, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "bkl-item-broken.h"
#include "bkl-entry.h"

enum {
    PROP_0,
    PROP_REASON,
};

struct _BklItemBrokenPrivate {
    char *reason;
};

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), BKL_TYPE_ITEM_BROKEN, BklItemBrokenPrivate))
G_DEFINE_TYPE (BklItemBroken, bkl_item_broken, BKL_TYPE_ITEM_EXTENDED);

static void
bkl_item_broken_finalize (GObject *object)
{
    BklItemBroken *self = (BklItemBroken *) object;

    g_free (self->priv->reason);

    g_signal_handlers_destroy (object);
    G_OBJECT_CLASS (bkl_item_broken_parent_class)->finalize (object);
}

static void
bkl_item_broken_dispose (GObject *object)
{
    G_OBJECT_CLASS (bkl_item_broken_parent_class)->dispose (object);
}

static void
bkl_item_broken_set_property (GObject      *object,
                              guint         prop_id,
                              const GValue *value,
                              GParamSpec   *pspec)
{
    switch (prop_id) {

    case PROP_REASON:
        break;

    default:
        break;
    }
}

static void
bkl_item_broken_get_property (GObject    *object,
                              guint       prop_id,
                              GValue     *value,
                              GParamSpec *pspec)
{
    switch (prop_id) {

    case PROP_REASON:
        break;

    default:
        break;
    }
}

static void
bkl_item_broken_class_init (BklItemBrokenClass *klass)
{
    GObjectClass *o_class = (GObjectClass *)klass;

    o_class->dispose = bkl_item_broken_dispose;
    o_class->finalize = bkl_item_broken_finalize;
    o_class->set_property = bkl_item_broken_set_property;
    o_class->get_property = bkl_item_broken_get_property;

    g_type_class_add_private (klass, sizeof (BklItemBrokenPrivate));

    g_object_class_install_property (o_class, PROP_REASON,
                                     g_param_spec_string ("reason", "", "", "",
                                                          G_PARAM_READWRITE |
                                                          G_PARAM_STATIC_STRINGS));
}

static void
bkl_item_broken_init (BklItemBroken *self)
{
    self->priv = GET_PRIVATE (self);
    bkl_item_set_item_type ((BklItem *) self, BKL_ITEM_TYPE_BROKEN);
}

BklItemBroken *
bkl_item_broken_new (void)
{
    BklItemBroken *broken;

    broken = g_object_new (BKL_TYPE_ITEM_BROKEN, NULL);
    return broken;
}

#define IS_EMPTY_STRING(s) ((s) == NULL || *(s) == '\0')
BklItemBroken *
bkl_item_broken_new_from_field (KozoField *field)
{
    BklItemBroken *broken;
    const char *data;

    broken = g_object_new (BKL_TYPE_ITEM_BROKEN, NULL);

    data = kozo_field_get_value_string (field, BKL_BROKEN_FIELD_REASON);
    if (!IS_EMPTY_STRING (data)) {
        bkl_item_broken_set_reason (broken, data);
    }

    return broken;
}

GSList *
bkl_item_broken_get_fields (BklItemBroken *item)
{
    BklItemBrokenPrivate *priv = item->priv;
    GSList *fields = NULL;

    fields = g_slist_prepend (fields, g_strdup (priv->reason));

    return fields;
}

void
bkl_item_broken_set_reason (BklItemBroken *item,
                            const char    *reason)
{
    g_free (item->priv->reason);
    item->priv->reason = g_strdup (reason);
}

const char *
bkl_item_broken_get_reason (BklItemBroken *item)
{
    return item->priv->reason;
}
