'''This is the bcfg2 tool for the Gentoo Portage system.'''
__revision__ = '$Revision: 2870 $'

import re
import Bcfg2.Client.Tools

class Portage(Bcfg2.Client.Tools.PkgTool):
    '''The Gentoo toolset implements package and service operations and inherits
    the rest from Toolset.Toolset'''
    __name__ = 'Portage'
    __execs__ = ['/usr/bin/emerge', '/usr/bin/equery']
    __important__ = ['/etc/make.conf']
    __handles__ = [('Package', 'ebuild')]
    __req__ = {'Package': ['name', 'version']}
    pkgtype = 'ebuild'
    # requires a working PORTAGE_BINHOST in make.conf
    pkgtool = ('emerge --getbinpkgonly %s', ('=%s-%s', ['name', 'version']))
    
    def __init__(self, logger, cfg, setup, states):
        Bcfg2.Client.Tools.PkgTool.__init__(self, logger, cfg, setup, states)
        self.cfg = cfg
        self.installed = {}
        self.RefreshPackages()
        
    def RefreshPackages(self):
        '''Refresh memory hashes of packages'''
        cache = self.cmd.run("equery -q list")[1]
        self.installed = {}
        for pkg in cache:
            pattern = re.compile('(.*)-(\d.*)')
            if pattern.match(pkg):
                name = pattern.match(pkg).group(1)
                version = pattern.match(pkg).group(2)
            self.installed[name] = version

    def VerifyPackage(self, entry, modlist):
        '''Verify package for entry'''
        if not entry.attrib.has_key('version'):
            self.logger.info("Cannot verify unversioned package %s" %
               (entry.attrib['name']))
            return False
        if self.installed.has_key(entry.attrib['name']):
            if self.installed[entry.attrib['name']] == entry.attrib['version']:
                if not self.setup['quick'] and \
				entry.get('verify', 'true') == 'true':
                    output = self.cmd.run \
				    ("/usr/bin/equery check =%s 2>&1 |grep '!!!' \
					| awk '{print $2}'" % entry.get('name'))[1]
                    if [filename for filename in output \
				    if filename not in modlist]:
                        return False
                return True
            else:
                entry.set('current_version', self.installed[entry.get('name')])
                return False
        entry.set('current_exists', 'false')
        return False

    def RemovePackages(self, packages):
        '''Deal with extra configuration detected'''
        if len(packages) > 0:
            self.logger.info('Removing packages:')
            self.logger.info(packages)
            self.cmd.run("emerge --unmerge --quiet =%s" % " =".join(packages))
            self.RefreshPackages()
            self.extra = self.FindExtraPackages()
              
        
