/* pristines.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__PRISTINES_H
#define INCLUDE__LIBARCH__PRISTINES_H


#include "hackerlab/machine/types.h"
#include "libawk/relational.h"
#include "libarch/archive.h"
#include "libarch/project-tree.h"



enum arch_pristine_search_scope
{
  arch_tree_pristine_search,
  arch_cache_dir_pristine_search,
};



/* automatically generated __STDC__ prototypes */
extern void arch_make_pristine (arch_project_tree_t * tree, t_uchar * archive, t_uchar * revision);
extern void arch_add_pristine (int chatter_fd, arch_project_tree_t * tree, struct arch_archive * arch, t_uchar * archive, t_uchar * revision);
extern void arch_install_pristine (arch_project_tree_t * tree, t_uchar * archive, t_uchar * revision, t_uchar * source);
extern rel_table arch_pristines (t_uchar * tree_root,
                                 t_uchar * archive_limit,
                                 t_uchar * limit);
extern arch_project_tree_t * arch_find_pristine (arch_project_tree_t * tree,
                                     arch_patch_id * revision,
                                     enum arch_pristine_search_scope scope);
#endif  /* INCLUDE__LIBARCH__PRISTINES_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (pristines.h)
 */
