/* archive-cache.c:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/bugs/exception.h"
#include "hackerlab/fs/file-names.h"
#include "hackerlab/mem/talloc.h"
#include "hackerlab/vu/safe.h"
#include "libfsutils/tmp-files.h"
#include "libfsutils/rmrf.h"
#include "libarch/local-cache.h"
#include "libarch/archive-cache.h"


void
arch_archive_cache (int chatter_fd, struct arch_archive * arch, t_uchar * archive, t_uchar * revision, arch_project_tree_t * cache)
{
  t_uchar * tmp_dir = 0;
  t_uchar * pristine_dir = 0;

  tmp_dir = talloc_tmp_file_name (talloc_context, ".", ",,archive-cache-revision");
  pristine_dir = file_name_in_vicinity (0, tmp_dir, revision);

  safe_mkdir (tmp_dir, 0777);
  safe_mkdir (pristine_dir, 0777);

  pristine_dir = arch_find_or_make_tmp_local_copy  (chatter_fd, tmp_dir, cache, NULL, arch, archive, revision);
  
  {
    t_uchar * errstr;

    if (arch_archive_put_cached (&errstr, arch, revision, pristine_dir))
      {
        safe_printfmt (2, "cacherev: unable to store cached revision of %s/%s (%s)\n", archive, revision, errstr);
        exit (1);
      }
  }

  rmrf_file (tmp_dir);

  talloc_free (tmp_dir);
  lim_free (0, pristine_dir);
}



/* tag: Tom Lord Wed Jun 11 14:15:15 2003 (archive-cache.c)
 */
