/* annotated-file.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005 Canonical Limited
 * 	Authors: Robert Collins <robert.collins@canonical.com>
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__ANNOTATED_FILE_H
#define INCLUDE__LIBARCH__ANNOTATED_FILE_H

#include "hackerlab/arrays/ar.h"
#include "libawk/relational.h"
#include "libarch/patch.h"
#include "libarch/file-offset-mapper.h"

/* A annotation builder.
 * provides a builder interface for assembling annotation data
 * about a revision
 */
typedef struct arch_annotated_file_
{
    t_uchar *file_id;
    arch_patch_t ** lines;
    int unknown_lines;
    int max_lines;
    /* the mapper should be maintained by the builder when we get to the 
     * multi-branch code 
     */
    file_offset_mapper_t mapper;
} arch_annotated_file_t;

/* for derived classes only */
extern void arch_annotated_file_init (arch_annotated_file_t *file, t_uchar const * file_id, int lines);
extern void arch_annotated_file_finalise (arch_annotated_file_t *file);
/* user facing api */
extern arch_annotated_file_t * arch_annotated_file_new (void * context, t_uchar const *file_id, int lines);
extern void arch_annotated_file_note_line (arch_annotated_file_t *file,
                                           int line, arch_patch_t *patch,
                                           int final);
extern void arch_annotated_file_note_subtract (arch_annotated_file_t *file, int line);

#endif /* INCLUDE__LIBARCH__ANNOTATED_FILE_H */
