<?php

class DbIndexStore extends Index {

var $dir;
var $contentdb; // word -> paths
var $keyworddb; // keyword -> paths
var $timedb;    // path -> time of last index
var $dbtype;
var $open = false;

var DbIndexStore($configstr) {
	
	if (function_exists('dba_handlers')) {
		$handlers = dba_handlers();
		if (in_array('db4',$handlers))
			$this->dbtype='db4';
		elseif (in_array('db2',$handlers))
			$this->dbtype='db2';
	}
	else {
		$this->dbtype='none';
	}
		
	$this->dir = $search_data_dir;
	if (!is_dir($this->dir)) {
		if (!is_writeable(dirname($this->dir))) {
			$user = posix_getpwuid(posix_getuid());
			die(dirname($this->dir) . " must be writeable by " . $user['name']);
		}
		else {
			mkdir($this->dir);
		}
	}

}

// mode of 'c' is broken before php 4.3.5
function open($mode='w') {
	if (!$this->open) {
		foreach(array('content','keyword','time') as $db) {
			if (! file_exists("$this->dir/$db.db") ) {
				$rc = dba_open("$this->dir/$db.db", 'n', $this->dbtype );
				if ($rc) dba_close($rc);
			}
			$dbfield = $db . 'db';
			$filename = "$this->dir/$db.db";
			$handle = dba_open($filename, $mode, $this->dbtype );
			if($handle == false) {
				$msg = "Couldn't write to $filename ($this->dbtype)";
				if (!is_writeable($filename)) {
					$user = posix_getpwuid(posix_getuid());
					$msg .= "<br>That file must be writeable by " . $user['name'];
				}
				die($msg);
			}
			else {
				$this->$dbfield = $handle;
			}
		}
	}
	$this->open = true;
}

function close() {
	if ($this->open) {
		dba_close($this->contentdb);        
		dba_close($this->keyworddb);
		dba_close($this->timedb);
	}
	$this->open = false;
}

// deletes all indexes
function clear() {
	$this->close();
	@unlink("$this->dir/content.db");
	@unlink("$this->dir/keyword.db");
	@unlink("$this->dir/time.db");	
}

function getByKeyword($keyword) {
	$pages = dba_fetch($keyword,$this->keyworddb);
	return array_filter(explode('|',$pages),'strlen');
}

function getByContent($str) {
	$pages = dba_fetch($str,$this->contentdb);
	return array_filter(explode('|',$pages),'strlen');
}

function getByMTime($timestamp) {
	#$pages = dba_fetch($keyword,$this->keyworddb);
	#return explode('|',$pages);
	return array();
}


function setContent($path, $words) {
	$db = &$this->contentdb;
	foreach($words as $word) {
		if ( dba_exists($word,$db) ) {
			$pages = dba_fetch($word, $db);
			if (!strstr($pages,"|$path/|")) {
				$pages .= "$path/|";
				dba_replace($word, $pages,$db);
			}
		}
		else {
			dba_insert($word,"|$page->path/|",$db);
		}
	}
}

function setKeywords($path,$words) {
	$db = &$this->keyworddb;
	foreach($words as $word) {
		if ( dba_exists($word,$db) ) {
			$pages = dba_fetch($word, $db);
			if (!strstr($pages,"|$path/|")) {
				$pages .= "$path/|";
				dba_replace($word, $pages,$db);
			}
		}
		else {
			dba_insert($word,"|$path/|",$db);
		}
	}
}

function setIndexedTime($path,$timestamp) {
	$db = &$this->timedb;
	if ($timestamp == 0) {
		if ( dba_exists("$path/",$db) )
			dba_delete("$path/", $db);
	}
	elseif ( dba_exists("$path/",$db) ) {
		dba_replace("$path/", $timestamp, $db);
	}
	else {
		dba_insert("$path/", $timestamp, $db);
	}
}

function getIndexTime($path) {
	$db = &$this->timedb;
	if ( dba_exists("$path/",$db) )
		return dba_fetch("$path/", $db);
	else
		return 0;
}

function remove($path) {
/*
	this doesn't work right now.
	
	## content db 
	$db = &$this->contentdb;
	$content = $page->get('content');
	$content = str_replace("\n",' ',$content);
	$content = preg_replace("/[^\w\s\d]/",'',$content);
	$content = strtolower($content);
	$words = explode(" ", $content);
#	$words = array_unique($words);
	foreach($words as $word) {
		$word = trim($word);
		if ($word == '' || strlen($word) <= 2) continue;
		if (isset($this->exclude[$word])) continue;		
		if ( dba_exists($word,$db) ) {
			$pages = dba_fetch($word, $db);
			$pages = str_replace("|$page->path/|", '|', $pages);
			if ($pages=='|')
				dba_delete($word, $db);
			else
				dba_replace($word, $pages, $db);
		}
	}
	
	## keyword db
	$db = &$this->keyworddb;
	$name  = $this->tokenize(basename($page->path));
	$title = $this->tokenize($page->get('title'));
	$keywords = $this->tokenize($page->get('keywords'));
	$words = array_merge($name,$title,$keywords);
#	$words = array_unique($words);
	foreach($words as $word) {
		$word = trim($word);
		if ($word == '') continue;
		if (isset($this->exclude[$word])) continue;
		if ( dba_exists($word,$db) ) {
			$pages = dba_fetch($word, $db);
			$pages = str_replace("|$page->path/|", '|', $pages);
			if ($pages=='|')
				dba_delete($word, $db);
			else
				dba_replace($word, $pages, $db);
		}
	}
*/
}

function rename($pathold, $pathnew) {
/*
	$db = &$this->timedb;
	$key = dba_firstkey( $db );
	while ( $key != false ) {
		if (preg_match("'^$old/'", $key)) {
			$value = dba_fetch($key,$db);
			dba_delete($key,$db);
			$key = preg_replace("'^$old/'","$new/",$key);
			dba_insert($key, $value, $db);
		}
		$key = dba_nextkey( $db );
	}

	foreach(array('contentdb','keyworddb') as $dbname) {
		$db = &$this->$dbname;
		$key = dba_firstkey( $db );
		while ( $key != false ) {
			$value = dba_fetch( $key, $db);
			if (strstr($value,"|$old/")) {
				$value = str_replace("|$old/","|$new/",$value);
				dba_replace($key,$value,$db);
			}
			$key = dba_nextkey( $db );
		}
	}
*/
}

// debug function
function dump() {
	if ($this->dbtype=='none') return;
	
	$this->opendb();	
	echo "<table><tr><th>key</th><th>value</th></tr>\n";
	foreach(array('contentdb','keyworddb','timedb') as $dbname) {
		$db = &$this->$dbname;
		$key = dba_firstkey( $db );
		while ( $key != false ) {
			$value = dba_fetch( $key, $db);
			print "<tr><td>'$key'</td>";
			print "<td>'$value'</td></tr>\n";
			$key = dba_nextkey( $db );
		}
	}
	echo "</table><br><br>";
}


} // end class

return;
?>
