SET(BALL_BOOST_COMPONENTS system thread iostreams asio)
FIND_PACKAGE(Boost COMPONENTS ${BALL_BOOST_COMPONENTS} QUIET)

IF (NOT Boost_VERSION) ## we cannot test for Boost_FOUND since this requires all components
	MESSAGE(SEND_ERROR "Could not find a suitable boost installation! This is a required dependency for BALL! Try setting BOOST_ROOT in ccmake!")
ELSE()
	SET(BOOST_LIBRARIES "")
	FOREACH(COMPONENT ${BALL_BOOST_COMPONENTS})
		STRING(TOUPPER ${COMPONENT} COMPONENT)
		
		IF (Boost_${COMPONENT}_FOUND)
			SET(BALL_HAS_BOOST_${COMPONENT} TRUE)
			LIST(APPEND BOOST_LIBRARIES ${Boost_${COMPONENT}_LIBRARY})
		ENDIF()
	ENDFOREACH()
	
	## For asio, we have some more work to do...
	IF (Boost_ASIO_FOUND)
		SET(BALL_HAS_BOOST_ASIO TRUE)
		SET(BALL_HAS_ASIO TRUE)
		SET(BALL_ASIO_NAMESPACE "boost::asio")
	ELSE()
		## Try to find asio as a standalone lib
		FIND_PATH(ASIO_INCLUDE_DIR NAMES asio.hpp)
		IF (ASIO_INCLUDE_DIR)
			SET(BALL_HAS_ASIO TRUE)
			SET(BALL_HAS_BOOST_ASIO FALSE)
			SET(BALL_ASIO_NAMESPACE "asio")
		ENDIF()
	ENDIF()
	SET(BOOST_INCLUDE_DIRS ${Boost_INCLUDE_DIRS})

	IF(ASIO_INCLUDE_DIR)
		SET(BOOST_INCLUDE_DIRS ${ASIO_INCLUDE_DIR})
	ENDIF()
ENDIF()
