# Arch Perl library, Copyright (C) 2005 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::triggers::list;
use base 'AXP::Command::triggers';

sub optusage {
	"[options] [limit ...]"
}

sub infoline {
	"list all defined triggers"
}

sub options {
	(
		show_vars   => { sh => 'v', desc => "show associated user variables" },
		show_state  => { sh => 's', desc => "show associated state" },
		show_action => { sh => 'a', desc => "show associated action" },
		all         => { sh => 'A', desc => "show all associated data" },
		no_nums     => { sh => 'N', desc => "do not show numbers" },
		__PACKAGE__->limits_option,
	)
}

sub helptext {
	q{
		Print a list of all defined triggers.

		By default only the limit (i.e. arch name) is shown.  Optionally,
		for every trigger also show its user variables (pairs KEY=VALUE),
		state	(last processed revisions) and action script.
	}
}

sub _tab_pad ($) {
	my $str = shift || "(none)";
	$str = [ map { "$_=$str->{$_}" } sort keys %$str ] if ref($str) eq 'HASH';
	$str = join("", map { "$_\n" } @$str) if ref($str) eq 'ARRAY';
	$str =~ s/^/\t/mg;
	$str =~ s/\s+$//s;
	return "$str\n";
}

sub execute {
	my $self = shift;
	my %opt = %{$self->{options}};

	my $num = 1;
	my $show_nums = !$opt{no_nums} && -t STDOUT;
	$opt{show_vars} = $opt{show_state} = $opt{show_action} = 1 if $opt{all};

	my @names = @ARGV;
	@names = @{$self->all_trigger_names} unless $opt{limits} || @names;

	foreach my $name (@names) {
		my $trigger = $self->load_trigger($name);
		$name = $trigger->{name};

		my $slave_suffix = $trigger->{is_slave}? " (slave)": "";
		print $num++, ". " if $show_nums;
		print "$name$slave_suffix\n";
		print _tab_pad($trigger->{vars}) if $opt{show_vars};
		print _tab_pad($trigger->{state}) if $opt{show_state};
		print _tab_pad($trigger->{action}) if $opt{show_action};
	}
}

1;
