# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::registry::list;
use base 'AXP::Command::registry';

sub infoline {
	"list archives and branches hosted on the supermirror"
}

sub optusage {
	"[options] [archive]"
}

sub helptext {
	q{
		Currently, sourcecontrol.net provides a mirror for most of the
		public free software Arch archives. It provides a kind of the
		registry de-facto.

		This command lists all archives hosted on the supermirror, and
		optionally their locations, and optionally all their versions.

		If a limit argument is given, then only list parameters of one
		given archive, or nothing if the archive is not found.
	}
}

sub execute {
	my $self = shift;

	my $archive = shift @ARGV;
	die "Invalid archive name ($archive)\n"
		if $archive && $archive !~ /.+@.+/;

	my $archive_versions = $self->registry->supermirror_archive_versions;
	if ($archive && $archive_versions) {
		my $versions = $archive_versions->{$archive};
		return unless $versions;
		$archive_versions = { $archive => $versions };
	}
	$self->print_output($archive_versions);
}

1;
