/*
   eeprom.S

   Contributors:
     Created by Marek Michalkiewicz <marekm@linux.org.pl>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "macros.inc"
#include "ctoasm.inc"

/* the same library is used for 2313 and 8515 for now -
   I hope writing 0 to non-existent EEARH doesn't hurt... */
#ifndef EEARH
#define EEARH (EEARL+1)
#endif

#define addr_hi rP0
#define addr_lo rP1
#define res_hi rP0
#define res_lo rP1

#ifdef L_eeprom_rb
/* read one byte from EEPROM */
/* unsigned char eeprom_rb(unsigned int addr); */
/* addr = r25:r24, result = r25(=0):r24 */

	.section .text
	.global _U(eeprom_rb)

_U(eeprom_rb):
	sbic	EECR, EEWE
	rjmp	_U(eeprom_rb)	/* make sure EEPROM is ready */
#ifdef EEARH
	out	EEARH, addr_hi
#endif
	out	EEARL, addr_lo
	sbi	EECR, EERE
	clr	res_hi		/* gcc wants result extended to "int"? */
	in	res_lo, EEDR
	ret
#endif /* L_eeprom_rb */

#ifdef L_eeprom_rw
/* read a little endian 16-bit word from EEPROM */
/* unsigned int eeprom_rw(unsigned int addr); */
/* addr = r25:r24, result = r25:r24 */

	.global _U(eeprom_rw)

_U(eeprom_rw):
	sbic	EECR, EEWE
	rjmp	_U(eeprom_rw)	/* make sure EEPROM is ready */
#ifdef EEARH
	out	EEARH, addr_hi
#endif
	out	EEARL, addr_lo
	sbi	EECR, EERE
	adiw	addr_lo, 1
	in	__tmp_reg__, EEDR
#ifdef EEARH
	out	EEARH, addr_hi
#endif
	out	EEARL, addr_lo
	sbi	EECR, EERE
	mov	res_lo, __tmp_reg__
	in	res_hi, EEDR
	ret
#endif /* L_eeprom_rw */

#ifdef L_eeprom_wb
/* write a byte to EEPROM */
/* void eeprom_wb(unsigned int addr, unsigned char val); */
/* addr = r25:r24, val = r22 */
#define val rP3

	.global _U(eeprom_wb)

_U(eeprom_wb):
	sbic	EECR, EEWE
	rjmp	_U(eeprom_wb)	/* make sure EEPROM is ready */
#ifdef EEARH
	out	EEARH, addr_hi
#endif
	out	EEARL, addr_lo
	out	EEDR, val
	in	__tmp_reg__, SREG
	cli			; /* no ints between setting EEMWE and EEWE */
	sbi	EECR, EEMWE
	sbi	EECR, EEWE
	out	SREG, __tmp_reg__
	ret
#undef val
#endif /* L_eeprom_wb */

#undef addr_hi
#undef addr_lo
#undef res_hi
#undef res_lo

#define buf_hi rP0
#define buf_lo rP1
#define addr_hi rP2
#define addr_lo rP3
#define n_hi rP4
#define n_lo rP5

#ifdef L_eeprom_read_block
/* read a block of bytes from EEPROM */
/* void eeprom_read_block(void *buf, unsigned int addr, size_t n); */
/* buf = r25:r24, addr = r23:r22, n = r21:r20 */

	.global _U(eeprom_read_block)

_U(eeprom_read_block):
	cp	n_lo, __zero_reg__
	cpc	n_hi, __zero_reg__
	breq	eeprom_read_block_done
	LOAD_X(buf_lo, buf_hi)
eeprom_read_block_busy:
	sbic	EECR, EEWE
	rjmp	eeprom_read_block_busy	/* make sure EEPROM is ready */
eeprom_read_block_loop:
#ifdef EEARH
	out	EEARH, addr_hi
#endif
	out	EEARL, addr_lo
	sbi	EECR, EERE
	subi	addr_lo, lo8(-1)
	sbci	addr_hi, hi8(-1)
	in	__tmp_reg__, EEDR
	st	X+, __tmp_reg__
	subi	n_lo, lo8(1)
	sbci	n_hi, hi8(1)
	brne	eeprom_read_block_loop
eeprom_read_block_done:
	ret
#endif /* L_eeprom_read_block */

