/*
   iom8.h - internal register definitions for ATmega8

   Contributors:
     Created by Marek Michalkiewicz <marekm@linux.org.pl>
     Edited by Pieter Conradie <pieter@intricode.com>

   THIS SOFTWARE IS NOT COPYRIGHTED

   This source code is offered for use in the public domain.  You may
   use, modify or distribute it freely.

   This code is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  ALL WARRANTIES, EXPRESS OR IMPLIED ARE HEREBY
   DISCLAIMED.  This includes but is not limited to warranties of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef __IOM8
#define __IOM8 1

#define AVR_ENHANCED 1

/* I/O space addresses */

/* TWI stands for "Two Wire Interface" or "TWI Was I2C(tm)" */
#define TWBR	0x00
#define TWSR	0x01
#define TWAR	0x02
#define TWDR	0x03

/* ADC */
#define ADCL	0x04
#define ADCH	0x05
#define ADCSR	0x06
#define ADMUX	0x07

/* analog comparator */
#define ACSR	0x08

/* USART */
#define UBRRL	0x09
#define UCSRB	0x0A
#define UCSRA	0x0B
#define UDR	0x0C

/* SPI */
#define SPCR	0x0D
#define SPSR	0x0E
#define SPDR	0x0F

/* Port D */
#define PIND	0x10
#define DDRD	0x11
#define PORTD	0x12

/* Port C */
#define PINC	0x13
#define DDRC	0x14
#define PORTC	0x15

/* Port B */
#define PINB	0x16
#define DDRB	0x17
#define PORTB	0x18

/* EEPROM */
#define EECR	0x1C
#define EEDR	0x1D
#define EEARL	0x1E
#define EEARH	0x1F

#define UCSRC	0x20
#define UBRRH	0x20

#define WDTCR	0x21
#define ASSR	0x22

/* Timer 2 */
#define OCR2	0x23
#define TCNT2	0x24
#define TCCR2	0x25

/* Timer 1 */
#define ICR1L	0x26
#define ICR1H	0x27
#define OCR1BL	0x28
#define OCR1BH	0x29
#define OCR1AL	0x2A
#define OCR1AH	0x2B
#define TCNT1L	0x2C
#define TCNT1H	0x2D
#define TCCR1B	0x2E
#define TCCR1A	0x2F

#define SFIOR	0x30

#define OSCCAL	0x31

/* Timer 0 */
#define TCNT0	0x32
#define TCCR0	0x33

#define MCUCSR	0x34
#define MCUCR	0x35

#define TWCR	0x36

#define SPMCR	0x37

#define TIFR	0x38
#define TIMSK	0x39

#define GIFR	0x3A
#define GIMSK	0x3B

/* 0x3C reserved (OCR0?) */

#define SPL	0x3D
#define SPH	0x3E
#define SREG	0x3F

/* Interrupt vectors */

#define SIG_INTERRUPT0		_vector_1
#define SIG_INTERRUPT1		_vector_2
#define SIG_OUTPUT_COMPARE2	_vector_3
#define SIG_OVERFLOW2		_vector_4
#define SIG_INPUT_CAPTURE1	_vector_5
#define SIG_OUTPUT_COMPARE1A	_vector_6
#define SIG_OUTPUT_COMPARE1B	_vector_7
#define SIG_OVERFLOW1		_vector_8
#define SIG_OVERFLOW0		_vector_9
#define SIG_SPI			_vector_10
#define SIG_UART_RECV		_vector_11
#define SIG_UART_DATA		_vector_12
#define SIG_UART_TRANS		_vector_13
#define SIG_ADC			_vector_14
#define SIG_EEPROM_READY	_vector_15
#define SIG_COMPARATOR		_vector_16
#define SIG_2WIRE_SERIAL	_vector_17
#define SIG_SPM_READY		_vector_18

#define END_VECTOR 		(18)
#define INT_VECT_SIZE (0x26)

/* Bit numbers */

/* GIMSK */
#define INT1	7
#define INT0	6
#define IVSEL	1
#define IVCE	0

/* GIFR */
#define INTF1	7
#define INTF0	6

/* TIMSK */
#define OCIE2	7
#define TOIE2	6
#define TICIE1	5
#define OCIE1A	4
#define OCIE1B	3
#define TOIE1	2
/* bit 1 reserved (OCIE0?) */
#define TOIE0	0

/* TIFR */
#define OCF2	7
#define TOV2	6
#define ICF1	5
#define OCF1A	4
#define OCF1B	3
#define TOV1	2
/* bit 1 reserved (OCF0?) */
#define TOV0	0

/* SPMCR */
#define SPMIE	7
#define RWWSB	6
/* bit 5 reserved */
#define RWWSRE	4
#define BLBSET	3
#define PGWRT	2
#define PGERS	1
#define SPMEN	0

/* TWCR */
#define TWINT	7
#define TWEA	6
#define TWSTA	5
#define TWSTO	4
#define TWWC	3
#define TWEN	2
/* bit 1 reserved (TWI_TST?) */
#define TWIE	0

/* TWAR */
#define TWGCE	0

/* TWSR */
#define TWS7	7
#define TWS6	6
#define TWS5	5
#define TWS4	4
#define TWS3	3
/* bit 2 reserved */
#define TWPS1	1
#define TWPS0	0

/* MCUCR */
#define SE	7
#define SM2	6
#define SM1	5
#define SM0	4
#define ISC11	3
#define ISC10	2
#define ISC01	1
#define ISC00	0

/* MCUCSR */
/* bits 7-4 reserved */
#define WDRF	3
#define BORF	2
#define EXTRF	1
#define PORF	0

/* SFIOR */
/* bits 7-5 reserved */
#define ADHSM	4
#define ACME	3
#define PUD	2
#define PSR2	1
#define PSR10	0

/* TCCR0 */
/* bits 7-3 reserved */
#define CS02	2
#define CS01	1
#define CS00	0

/* TCCR2 */
#define FOC2	7
#define WGM20	6
#define COM21	5
#define COM20	4
#define WGM21	3
#define CS22	2
#define CS21	1
#define CS20	0

/* ASSR */
/* bits 7-4 reserved */
#define AS2	3
#define TCN2UB	2
#define OCR2UB	1
#define TCR2UB	0

/* TCCR1A */
#define COM1A1	7
#define COM1A0	6
#define COM1B1	5
#define COM1B0	4
#define FOC1A	3
#define FOC1B	2
#define WGM11	1
#define WGM10	0

/* TCCR1B */
#define ICNC1	7
#define ICES1	6
/* bit 5 reserved */
#define WGM13	4
#define WGM12	3
#define CS12	2
#define CS11	1
#define CS10	0

/* WDTCR */
/* bits 7-5 reserved */
#define WDCE	4
#define WDE	3
#define WDP2	2
#define WDP1	1
#define WDP0	0

/* UBRRH */
#define URSEL	7

/* UCSRC */
#define URSEL	7
#define UMSEL	6
#define UPM1	5
#define UPM0	4
#define USBS	3
#define UCSZ1	2
#define UCSZ0	1
#define UCPOL	0

/* EECR */
/* bits 7-4 reserved */
#define EERIE	3
#define EEMWE	2
#define EEWE	1
#define EERE	0

/* PORTB */
#define PB7	7
#define PB6	6
#define PB5	5
#define PB4	4
#define PB3	3
#define PB2	2
#define PB1	1
#define PB0	0

/* DDRB */
#define DDB7	7
#define DDB6	6
#define DDB5	5
#define DDB4	4
#define DDB3	3
#define DDB2	2
#define DDB1	1
#define DDB0	0

/* PINB */
#define PINB7	7
#define PINB6	6
#define PINB5	5
#define PINB4	4
#define PINB3	3
#define PINB2	2
#define PINB1	1
#define PINB0	0

/* PORTC */
#define PC7	 7
#define PC6	 6
#define PC5	 5
#define PC4	 4
#define PC3	 3
#define PC2	 2
#define PC1	 1
#define PC0	 0

/* DDRC */
#define DDC7	7
#define DDC6	6
#define DDC5	5
#define DDC4	4
#define DDC3	3
#define DDC2	2
#define DDC1	1
#define DDC0	0

/* PINC */
#define PINC7	7
#define PINC6	6
#define PINC5	5
#define PINC4	4
#define PINC3	3
#define PINC2	2
#define PINC1	1
#define PINC0	0

/* PORTD */
#define PD7	 7
#define PD6	 6
#define PD5	 5
#define PD4	 4
#define PD3	 3
#define PD2	 2
#define PD1	 1
#define PD0	 0

/* DDRD */
#define DDD7	7
#define DDD6	6
#define DDD5	5
#define DDD4	4
#define DDD3	3
#define DDD2	2
#define DDD1	1
#define DDD0	0

/* PIND */
#define PIND7	7
#define PIND6	6
#define PIND5	5
#define PIND4	4
#define PIND3	3
#define PIND2	2
#define PIND1	1
#define PIND0	0

/* SPSR */
#define SPIF	7
#define WCOL	6
#define SPI2X	0

/* SPCR */
#define SPIE	7
#define SPE	6
#define DORD	5
#define MSTR	4
#define CPOL	3
#define CPHA	2
#define SPR1	1
#define SPR0	0

/* UCSRA */
#define RXC	7
#define TXC	6
#define UDRE	5
#define FE	4
#define DOR	3
#define PE	2
#define U2X	1
#define MPCM	0

/* UCSRB */
#define RXCIE	7
#define TXCIE	6
#define UDRIE	5
#define RXEN	4
#define	TXEN	3
#define UCSZ2	2
#define RXB8	1
#define TXB8	0

/* ACSR */
#define ACD	7
#define ACBG	6
#define ACO	5
#define ACI	4
#define ACIE	3
#define ACIC	2
#define ACIS1	1
#define ACIS0	0

/* ADCSR */
#define ADEN	7
#define ADSC	6
#define ADFR	5
#define ADIF	4
#define ADIE	3
#define ADPS2	2
#define ADPS1	1
#define ADPS0	0

/* ADMUX */
#define REFS1	7
#define REFS0	6
#define ADLAR	5
/* bit 4 reserved */
#define MUX3	3
#define MUX2	2
#define MUX1	1
#define MUX0	0

/* Pointer registers (same for all AVR devices so far) */
#define XL r26
#define XH r27
#define YL r28
#define YH r29
#define ZL r30
#define ZH r31

/* Last memory addresses */
#define RAMEND		0x45F
#define XRAMEND		0x45F
#define E2END		0x1FF
#define FLASHEND	0x1FFF

#endif  /* __IOM8 */
