/*
** ATOP - System & Process Monitor
**
** The program 'atop' offers the possibility to view the activity of
** the system on system-level as well as process-level.
**
** Include-file describing prototypes and structures for visualization
** of counters.
** ================================================================
** Author:      Gerlof Langeveld - AT Computing, Nijmegen, Holland
** E-mail:      gerlof@ATComputing.nl
** Date:        July 2002
**
** This program is free software; you can redistribute it and/or modify it
** under the terms of the GNU General Public License as published by the
** Free Software Foundation; either version 2, or (at your option) any
** later version.
**
** This program is distributed in the hope that it will be useful, but
** WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
** See the GNU General Public License for more details.
*/
#define USERSTUB	9999999
#define MAXUSERSEL	64

struct syscap {
	count_t	availcpu;
	count_t	availmem;
	count_t	availdsk;
	count_t	availnet;
};

struct selection {
	char	username[256];
	uid_t	userid[MAXUSERSEL];

	char	procname[64];
	int	procnamesz;
	regex_t	procregex;
};

void	totalcap   (struct syscap *, struct sstat *, struct pstat *, int);
void	pricumproc (struct pstat *, int, int, int, int);
void	showgenproc(struct pstat *, double);
void	showmemproc(struct pstat *, double);
void	shownetproc(struct pstat *, double);
void	showstaproc(struct pstat *, double);
void	printg     (const char *, ...);
int	prisyst(struct sstat  *, int, int, int, int, int, int);
int	priproc(struct pstat  *, int, int, int, int, int, char *,
	        struct syscap *, char, struct selection *, int);
void	priphead(int, int, char *, char);
