
#ifndef __file_exception__
#define __file_exception__

#include <string>
#include "exception.hh"

namespace autil {

  struct WithFileException {
    string file;
    WithFileException(const string & f) 
      : file(f) {}
  };
  
  struct FileException : public Exception, public WithFileException {
    FileException(const string & f, const string & w) 
      : Exception(w), WithFileException(f) {}
    ~FileException() throw() {}
  protected: 
    FileException(const string & f) 
      : WithFileException(f)
    {}
  };

  struct CantReadFile : public FileException {
    CantReadFile(const string & f);
    ~CantReadFile() throw() {}
  };

  struct CantWriteFile : public FileException {
    CantWriteFile(const string & f);
    ~CantWriteFile() throw() {}
  };

  struct BadFileFormat : public FileException {
    BadFileFormat(const string & f, const string & m = "");
    ~BadFileFormat() throw() {}
  };

  struct RethrowWFile {
    virtual void rethrow_w_file(const string & f) const = 0;
  };
}

#endif
