
#include <pspell/error.h>
#include "config_data.hh"
#include "bad_value.hh"
#include "file_exceps.hh"

namespace autil {
  
  void ConfigData::throw_exception(const char * key) const {
    if (config_.error_number() == PERROR_UNKNOWN_KEY)
      throw UnknownKey(key, config_.error_message());
    else
      throw_exception(key, "");
  }

  void ConfigData::throw_exception(const char * key, const char * value) const {
    switch (config_.error_number()) {
    case PERROR_UNKNOWN_KEY:
      throw UnknownKey(key, config_.error_message());
    case PERROR_CANT_CHANGE_VALUE:
      throw CantChangeValue(key, config_.error_message());
    case PERROR_BAD_VALUE:
      throw BadValue(key, value, "", config_.error_message());
    }
    abort();
  }

  void ConfigData::throw_file_exception(const char * file) const {
    if (config_.error_number() == PERROR_CANT_READ_FILE)
      throw CantReadFile(file);
    else
      throw_exception("");
  }
}
