------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--                    G N A T P P . P R O C E S S I N G                     --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                   Copyright (C) 2001-2004, ACT Europe                    --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston,                                                                  --
--                                                                          --
-- GNATPP is maintained by ACT Europe (http://www.act-europe.fr).           --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains routines performing the main processing needed
--  by the pretty-printer.

with Asis;                use Asis;

with GNATPP.Source_Table; use GNATPP.Source_Table;

package GNATPP.Processing is

   procedure Main;
   --  This is the main "internal" driver for GNATPP. It processes the
   --  argument sources file-by-file, for each source in creates the tree (or
   --  checks the existence of the corresponding tree), defines and opens the
   --  corresponding Context, pretty-print the corresponding unit and deletes
   --  the tree (and ALI) file if needed.

   procedure Pretty_Print (Unit : Asis.Compilation_Unit; SF : SF_Id);
   --  This is the ASIS pretty-printer - it generates the "pretty" source for
   --  Unit. SF is the index of the source file corresponding to this unit in
   --  GNATPP source table. We have placed this procedure into the spec to make
   --  it possible to use other drivers for pretty-printer.

end GNATPP.Processing;
