/* $Id: ArkRenderer.cpp,v 1.3 2003/03/18 21:54:12 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2003 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <ArkRenderer.h>
#include <ArkSystem.h>

namespace Ark
{
   VersionInfo Renderer_VERSION = {"Renderer", 0,1,0};

   RendererFactory::RendererFactory() : Factory (Renderer_VERSION)
   {
   }
   
   Renderer *
   RendererFactory::CreateRenderer(const String &implname,
				   Cache *cache,
				   FactoryList *factlist)
   {
      if (factlist == 0)
	 factlist = Ark::Sys()->Factories();
      
      Ark::RendererFactory *rendererfac;
      if (!factlist->GetFactory(implname, &rendererfac, Renderer_VERSION))
	  {
		  const char* name = implname.c_str();
		  Ark::Sys()->Fatal("Cannot create the '%s' renderer factory !", name);

	  }
      
      return rendererfac->NewRenderer (cache);
   }

}

