use Date::Manip;

Date_Init("DateFormat = NONUS");  #change to US for mm/dd

package Argus;
use Argus::Support;

use vars qw ($Client_bin $RA $Local_IP_re $LocalTimeZone_re $Local_domain
             $Local_domain_re $Def_Host $Def_Port $Archive_root $Error
             @Errors $Accuracy $Notify $Home $Client_path $NotConfigured
	     $Archive_dir_template $Archive_file_template);


# Installation specific vars
if( defined $ENV{ARGUSHOME} ) {
    $Home =  $ENV{ARGUSHOME};
} else {
    $Home =  $ENV{HOME};
}
$Client_path = "$Home/bin";
$Archive_root = "$Home/data";

# Template for directory stucture where archived data is stored.
# By default Argus::Archive assumes a directory stucture of the form
# "$Archive_root/$Archive_dir_template/ where $Archive_dir_template
# is and strftime format string.
# 

#$Archive_dir_template = "%Y/%m/%d";   # eg  2001/03/05
$Archive_dir_template = "%Y.%m.%d";   # eg  2001.03.05

# an RE that will match all argus log files (you may have other file
# stored in the directory -- I do)  Argus::Archive assumes (by default)
# that sorting the filenames lexically will yeild the files in time
# order
$Archive_file_template = "^argus-*";

# If your archive tree does not conform to the above assumptions you 
# will need to modify the Argus/Archive.pm file to do 'the right thing'
# with your archive structure.

$Def_Host = 'localhost';
$Def_Port =  '561';

# Logger of errors and warnings.  This variable sets the default destination 
# for errors and warnings produced by the scripts.  They may be overridden in the
# config modules for the individual scripts
# defaults to STDERR

$LOG_TO = 'SYSLOG:Argus:deamon:warning:unix';
#$LOG_TO = 'Filename';

# site specific vars

$Local_IP = '130.216';
$Local_IP_re = '^130\.216|202\.37\.88\.';
# domains with same timezone - useful in NZ ;-) less useful elsewhere
# used to decide whether to report times in local time or UTC.
$LocalTimeZone_re = '\.nz$';   
$Local_domain_re = 'auckland\.ac\.nz$';
$Local_domain = 'auckland.ac.nz';

# who gets reports ?

$Notify = "R.fulton\@$Local_domain";    

#  How accurate are log times ?
$Accuracy = "GPS synchronized";


########################################################################
# determine OS stuff Based on Date::Manip.pm
#
# Copyright (c) 1995-2000 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.
#
###########################################################################
###########################################################################

use vars qw($OS %Lang %Curr %Cnf);


# Determine the type of OS...
$OS="Unix";
$OS="Windows"  if ((defined $^O and
                    $^O =~ /MSWin32/i ||
                    $^O =~ /Windows_95/i ||
                    $^O =~ /Windows_NT/i) ||
                   (defined $ENV{OS} and
                    $ENV{OS} =~ /MSWin32/i ||
                    $ENV{OS} =~ /Windows_95/i ||
                    $ENV{OS} =~ /Windows_NT/i));
$OS="Mac"      if ((defined $^O and
                    $^O =~ /MacOS/i) ||
                   (defined $ENV{OS} and
                    $ENV{OS} =~ /MacOS/i));
$OS="MPE"      if (defined $^O and
                   $^O =~ /MPE/i);
$OS="OS2"      if (defined $^O and
                   $^O =~ /os2/i);
$OS="VMS"      if (defined $^O and
                   $^O =~ /VMS/i);

# Determine if we're doing taint checking
$NoTaint = eval { local $^W; unlink "$^X$^T"; 1 };


1;

