/*
 * Copyright (c) 2000-2001 QoSient, LLC
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
 * Copyright (c) 1993, 1994 Carnegie Mellon University.
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear
 * in supporting documentation, and that the name of CMU not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  
 * 
 * CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 *
 */

/*
 * racount - argus data counting program.
 *
 * written by Carter Bullard
 * QoSient, LLC
 *
 */


#ifndef ArgusClient
#define ArgusClient
#endif

#include <argus_client.h>


long long totalflowrecords   = 0;
long long totaltcpflowrecs   = 0;
long long totaludpflowrecs   = 0;
long long totalicmpflowrecs  = 0;
long long totalipflowrecs    = 0;
long long totalarpflowrecs   = 0;
long long totalnonipflowrecs = 0;

int RaInitialized = 0;
void
ArgusClientInit ()
{
  if (!(RaInitialized)) {
     RaInitialized++;
  }
}




void
RaParseComplete (int sig)
{
   long long total_count, total_dst_count, total_src_count;
   long long total_bytes, total_dst_bytes, total_src_bytes;
   char *printStr = NULL;

   total_src_count = tcp_src_count + udp_src_count + icmp_src_count +
         ip_src_count + arp_src_count + nonip_src_count;
   total_dst_count = tcp_dst_count + udp_dst_count + icmp_dst_count +
         ip_dst_count + arp_dst_count + nonip_dst_count;
   total_count = total_dst_count + total_src_count;

   total_src_bytes = tcp_src_bytes + udp_src_bytes + icmp_src_bytes +
         ip_src_bytes + arp_src_bytes + nonip_src_bytes;
   total_dst_bytes = tcp_dst_bytes + udp_dst_bytes + icmp_dst_bytes +
         ip_dst_bytes + arp_dst_bytes + nonip_dst_bytes;
   total_bytes = total_dst_bytes + total_src_bytes;

   if (total_count) {
      printf ("%-10s records       total_pkts         src_pkts         dst_pkts      ", ArgusProgramName);
      printf ("total_bytes        src_bytes        dst_bytes\n");

#if defined(HAVE_SOLARIS) || defined(__FreeBSD__) || defined(__NetBSD__) || defined(__OpenBSD__)
      printStr = "%7s %10lld %16lld %16lld %16lld %16lld %16lld %16lld\n";
#else
      printStr = "%7s %10Ld %16Ld %16Ld %16Ld %16Ld %16Ld %16Ld\n";
#endif

      if (aflag) {
         if ((tcp_src_count + tcp_dst_count) > 0) {
            printf (printStr, "tcp", totaltcpflowrecs,
               tcp_dst_count + tcp_src_count, tcp_src_count, tcp_dst_count,
               tcp_dst_bytes + tcp_src_bytes, tcp_src_bytes, tcp_dst_bytes);
            if ((tcp_src_count + tcp_dst_count) == total_count)
               goto racount_done;
         }

         if ((udp_src_count + udp_dst_count) > 0) {
            printf (printStr, "udp", totaludpflowrecs,
               udp_dst_count + udp_src_count, udp_src_count, udp_dst_count,
               udp_dst_bytes + udp_src_bytes, udp_src_bytes, udp_dst_bytes);
            if ((udp_src_count + udp_dst_count) == total_count)
               goto racount_done;
         }

         if ((icmp_src_count + icmp_dst_count) > 0) {
            printf (printStr, "icmp", totalicmpflowrecs,
               icmp_dst_count + icmp_src_count, icmp_src_count, icmp_dst_count,
               icmp_dst_bytes + icmp_src_bytes, icmp_src_bytes, icmp_dst_bytes);
            if ((icmp_src_count + icmp_dst_count) == total_count)
               goto racount_done;
         }

         if ((ip_src_count + ip_dst_count) > 0) {
            printf (printStr, "ip", totalipflowrecs,
               ip_dst_count + ip_src_count, ip_src_count, ip_dst_count,
               ip_dst_bytes + ip_src_bytes, ip_src_bytes, ip_dst_bytes);
            if ((ip_src_count + ip_dst_count) == total_count)
               goto racount_done;
         }

         if ((arp_src_count + arp_dst_count) > 0) {
            printf (printStr, "arp", totalarpflowrecs,
               arp_dst_count + arp_src_count, arp_src_count, arp_dst_count,
               arp_dst_bytes + arp_src_bytes, arp_src_bytes, arp_dst_bytes);
            if ((arp_src_count + arp_dst_count) == total_count)
               goto racount_done;
         }

         if ((nonip_src_count + nonip_dst_count) > 0) {
            printf (printStr, "non-ip", totalnonipflowrecs,
               nonip_dst_count + nonip_src_count, nonip_src_count, nonip_dst_count,
               nonip_dst_bytes + nonip_src_bytes, nonip_src_bytes, nonip_dst_bytes);
            if ((nonip_src_count + nonip_dst_count) == total_count)
               goto racount_done;
         }
      }

      printf (printStr, "sum", totalflowrecords,
            total_count, total_src_count, total_dst_count,
            total_bytes, total_src_bytes, total_dst_bytes);

   } else
      printf ("No data seen.\n");

racount_done:

   fflush (stdout);
   _exit(0);
}


void ArgusClientTimeout ()
{
}

void
parse_arg (int argc, char**argv)
{
}


void
usage ()
{
   extern char version[];

   fprintf (stderr, "Racount Version %s\n", version);
   fprintf (stderr, "usage: %s \n", ArgusProgramName);
   fprintf (stderr, "usage: %s [ra-options] [- filter-expression]\n", ArgusProgramName);

   fprintf (stderr, "ra-options: -b             dump packet-matching code.\n");
   fprintf (stderr, "            -C             treat the remote source as a Cisco Netflow source.\n");
   fprintf (stderr, "            -D <level>     specify debug level\n");
   fprintf (stderr, "            -F <conffile>  read configuration from <conffile>.\n");
   fprintf (stderr, "            -h             print help.\n");
   fprintf (stderr, "            -P <portnum>   specify remote argus <portnum> (tcp/561).\n");
   fprintf (stderr, "            -r <file>      read argus data <file>. '-' denotes stdin.\n");
   fprintf (stderr, "            -S <host>      specify remote argus <host>.\n");
   fprintf (stderr, "            -t <timerange> specify <timerange> for reading records.\n");
   fprintf (stderr, "                  format:  timeSpecification[-timeSpecification]\n");
   fprintf (stderr, "                           timeSpecification: [mm/dd[/yy].]hh[:mm[:ss]]\n");
   fprintf (stderr, "                                               mm/dd[/yy]\n");
#ifdef ARGUS_SASL
   fprintf (stderr, "            -U <user/auth> specify <user/auth> authentication information.\n");
#endif
   fprintf (stderr, "            -T <secs>      attach to remote server for T seconds.\n");
   exit(1);
}

void
RaProcessRecord (struct ArgusRecord *argus)
{
   totalflowrecords++;
}


void
process_man (struct ArgusRecord *argus)
{
}


void
process_tcp (struct ArgusRecord *argus)
{
   totaltcpflowrecs++;

   tcp_src_count += argus->argus_far.src.count;
   tcp_dst_count += argus->argus_far.dst.count;

   if (Aflag) {
      tcp_src_bytes += argus->argus_far.src.appbytes;
      tcp_dst_bytes += argus->argus_far.dst.appbytes;
   } else {
      tcp_src_bytes += argus->argus_far.src.bytes;
      tcp_dst_bytes += argus->argus_far.dst.bytes;
   }

   RaProcessRecord (argus);
}


void
process_icmp (struct ArgusRecord *argus)
{
   totalicmpflowrecs++;

   icmp_src_count += argus->argus_far.src.count;
   icmp_dst_count += argus->argus_far.dst.count;

   if (Aflag) {
      icmp_src_bytes += argus->argus_far.src.appbytes;
      icmp_dst_bytes += argus->argus_far.dst.appbytes;
   } else {
      icmp_src_bytes += argus->argus_far.src.bytes;
      icmp_dst_bytes += argus->argus_far.dst.bytes;
   }

   RaProcessRecord (argus);
}


void
process_udp (struct ArgusRecord *argus)
{
   totaludpflowrecs++;

   udp_src_count += argus->argus_far.src.count;
   udp_dst_count += argus->argus_far.dst.count;

   if (Aflag) {
      udp_src_bytes += argus->argus_far.src.appbytes;
      udp_dst_bytes += argus->argus_far.dst.appbytes;
   } else {
      udp_src_bytes += argus->argus_far.src.bytes;
      udp_dst_bytes += argus->argus_far.dst.bytes;
   }

   RaProcessRecord (argus);
}


void
process_ip (struct ArgusRecord *argus)
{
   totalipflowrecs++;

   ip_src_count += argus->argus_far.src.count;
   ip_dst_count += argus->argus_far.dst.count;

   if (Aflag) {
      ip_src_bytes += argus->argus_far.src.appbytes;
      ip_dst_bytes += argus->argus_far.dst.appbytes;
   } else {
      ip_src_bytes += argus->argus_far.src.bytes;
      ip_dst_bytes += argus->argus_far.dst.bytes;
   }

   RaProcessRecord (argus);
}


void
process_arp (struct ArgusRecord *argus)
{
   totalarpflowrecs++;

   arp_src_count += argus->argus_far.src.count;
   arp_dst_count += argus->argus_far.dst.count;

   if (Aflag) {
      arp_src_bytes += argus->argus_far.src.appbytes;
      arp_dst_bytes += argus->argus_far.dst.appbytes;
   } else {
      arp_src_bytes += argus->argus_far.src.bytes;
      arp_dst_bytes += argus->argus_far.dst.bytes;
   }
   RaProcessRecord (argus);
}


void
process_non_ip (struct ArgusRecord *argus)
{
   totalnonipflowrecs++;

   nonip_src_count += argus->argus_far.src.count;
   nonip_dst_count += argus->argus_far.dst.count;

   if (Aflag) {
      nonip_src_bytes += argus->argus_far.src.appbytes;
      nonip_dst_bytes += argus->argus_far.dst.appbytes;
   } else {
      nonip_src_bytes += argus->argus_far.src.bytes;
      nonip_dst_bytes += argus->argus_far.dst.bytes;
   }

   RaProcessRecord (argus);
}

