# without-archive.sh: invoke a command outside with-archive
# 
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 
errname=with-archive

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "invoke a command outside with-archive\\n"
		printf "usage: with-archive [options] command [args...]\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
		printf "Invoke COMMAND, but only after clearing the environment\\n"
		printf "variables used by \"larch with-archive\".\\n"
   		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 

    -*)			printf "with-archive: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -lt 1 ; then
    printf "usage: with-archive [options] command [args...]\\n" 1>&2
    printf "try --help\\n" 1>&2
    exit 1
fi

################################################################
# Disconnect and Execute the Command
# 

WFTP_MY_ADDR=
WFTP_SITE=
WFTP_SECRET=
WFTP_SITE_ADDR=
WFTP=

WITHARCHIVE=
WITHARCHIVELOC=

exec "$@"

# tag: Tom Lord Tue Jan 22 06:19:22 2002 (remote/without-archive.sh)
#
