# 
# copy-tree-precious.sh - copy precious files between project tree
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
                printf "copy precious files from one project tree to another\\n"
                printf "usage: copy-tree-precious [options] old-dir new-dir\\n"
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
                printf "Copy precious files and nested project trees from the directory\\n"
		printf "OLD-DIR to corresponding locations in NEW-DIR.\\n"
                printf "\\n"
                printf "When copying precious files, this command won't create new source\\n"
		printf "directories in NEW-DIR.  If a precious file in OLD-DIR is in a\\n"
		printf "directory not found in NEW-DIR, that file is copied to a subdirectory\\n"
		printf "of NEW-DIR/++lost-precious.\\n"
                printf "\\n"
                printf "When copying nested project trees, the entire tree is copied, including\\n"
                printf "precious files (but not junk, backup, and unrecognized files).\\n"
                printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=

while test $# -ne 0 ; do

  case "$1" in 

    -R|--root)          shift
                        if test $# -eq 0 ; then
                          printf "copy-tree-precious: -R and --root require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 1
                        fi
                        archroot="$1"
                        shift
                        ;;

    -A|--archive)       shift
                        if test $# -eq 0 ; then
                          printf "copy-tree-precious: -A and --archive require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 1
                        fi
                        archive="$1"
                        shift
                        ;;

    -*)                 printf "copy-tree-precious: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 2 ; then
  printf "usage: copy-tree-precious [options] old-dir new-dir\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

old_dir="$1"
shift

new_dir="$1"
shift

here="`pwd`"

cd "$old_dir"
old_dir="`pwd`"

cd "$here"
cd "$new_dir"
new_dir="`pwd`"


################################################################
# Copy Nested Project Trees
# 

cd "$old_dir"

larch inventory --trees \
| xargs -n 1 need-args "larch inventory --source --precious --all --nested --" \
| awk '{print $2}' \
| copy-file-list -- - "$old_dir" "$new_dir"



################################################################
# Make Space for Lost Precious Files
# 

cd "$new_dir"

mkdir ,,lost-precious.$$
cd ,,lost-precious.$$
lost_dir="`pwd`"

cd "$old_dir"

larch inventory --precious \
| awk -v new_dir="$new_dir" \
      -v lost_dir="$lost_dir" \
      '{ print "larch copy-or-stash \"" $0 "\" \"" new_dir "\" \"" lost_dir "\""; }' \
| $ARCH_SHELL -e 

if ! rmdir "$lost_dir" 2> /dev/null ; then
  mv "$lost_dir" "++lost-precious.`date +%Y-%m-%d`.$$"
fi

