# 
# patch-add-log.sh: add a new log file to a patch set
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

comand_line="$*"

################################################################
# special options
# 
# Some options are special:
# 
#	--version | -V
#	--help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec larch --version
                    ;;


      --help|-h)
		printf "add a new log file to a patch set\\n"
		printf "usage: patch-add-log [options] [--] patch-set-dir archive/revision log-file\\n"
		printf "\\n"
		printf " -V --version                  print version info\\n"
		printf " -h --help                     display help\\n"
		printf "\\n"
                printf " -R --root root                specify the local archive root\\n"
                printf " -A --archive archive          specify the archive name\\n"
                printf "\\n"
		printf "Modify the patch set in PATCH-SET-DIR so that it includes the\\n"
		printf "addition of LOG-FILE as a new file as a patch-log entry for\\n"
		printf "ARCHIVE/REVISION\\n"
		printf "\\n"
		exit 0
      		;;

      *)
		;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

archroot=
archive=

while test $# -ne 0 ; do

  case "$1" in 

    -R|--root)          shift
                        if test $# -eq 0 ; then
                          printf "patch-add-log: -R and --root require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 1
                        fi
                        archroot="$1"
                        shift
                        ;;

    -A|--archive)       shift
                        if test $# -eq 0 ; then
                          printf "patch-add-log: -A and --archive require an argument\\n" 1>&2
                          printf "try --help\\n" 1>&2
                          exit 1
                        fi
                        archive="$1"
                        shift
                        ;;

    --)			shift
    			break
			;;
			
    -*)			printf "patch-add-log: unrecognized option (%s)\\n" "$1" 1>&2
			printf "try --help\\n" 1>&2
			exit 1
			;;

    *)			break
    			;;

  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -ne 3 ; then
  printf "usage: patch-add-log [options] [--] patch-set-dir archive/revision log-file\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

delta="$1"
shift

archive_revision="$1"
shift

logfile="$1"
shift

################################################################
# Sanity Check and Process Defaults
# 

here="`pwd`"

cd "$delta"
delta="`pwd`"

cd "$here"
cd "`dirname \"$logfile\"`"
logfile="`pwd`/`basename \"$logfile\"`"

larch valid-package-name -e patch-add-log --patch-level "$archive_revision"

archive=`larch parse-package-name -R "$archroot" -A "$archive" --arch "$archive_revision"`
revision=`larch parse-package-name --non-arch "$archive_revision"`
category=`larch parse-package-name --basename "$revision"`
branch=`larch parse-package-name --package "$revision"`
version=`larch parse-package-name --package-version "$revision"`
lvl=`larch parse-package-name --lvl "$revision"`



################################################################
# Do It
# 

cd "$delta"

new_file="./{arch}/$category/$branch/$version/$archive/patch-log/$lvl"
new_file_tag="A_$new_file"

if grep -s -F -e "$new_file	$new_file_tag" mod-files-index ; then
  printf "patch-add-log: patch already has entry for that log file\\n" 1>&2
  printf "\\n" 1>&2
  exit 1
fi

if grep -s -F -e "$new_file	$new_file_tag" orig-files-index ; then
  printf "patch-add-log: patch already removes that log file\\n" 1>&2
  printf "\\n" 1>&2
  exit 1
fi

mv mod-files-index ,,tmp
printf "%s %s\\n" "$new_file" "$new_file_tag" > ,,tmp2
sort -m -k 2 ,,tmp ,,tmp2 > mod-files-index
rm ,,tmp ,,tmp2

# Because of the reliable tagging for {arch} directories,
# and the automatic creation of dirs needed for new files,
# there is no need to add directories containing this patch
# log entry.
# 

mkdir -p "new-files-archive/`dirname \"$new_file\"`"
cp -p "$logfile" "new-files-archive/$new_file"


# tag: Tom Lord Thu Dec 13 02:30:24 2001 (patch-sets/patch-add-log.sh)
#
